/*
 * Decompiled with CFR 0.152.
 */
package it.unipd.chess.views.permissions;

import it.unipd.chess.views.permissions.EntryId;

public class PermissionEntry {
    public static final byte WRITABLE = 0;
    public static final byte OWNER = 1;
    public static final byte VISIBLE = 2;
    public static String OWNER_ATR = "owner";
    public static String VISIBLE_ATR = "visible";
    public static String WRITE_ATR = "write";
    private EntryId id;
    private boolean owner;
    private boolean visible;
    private boolean write;

    public EntryId getId() {
        return this.id;
    }

    public boolean checkPermission(byte permission) {
        if (permission == 1) {
            return this.owner;
        }
        if (permission == 0) {
            return this.write;
        }
        if (permission == 2) {
            return this.visible;
        }
        return false;
    }

    public boolean isOwner() {
        return this.owner;
    }

    public boolean isWriteable() {
        return this.write;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public PermissionEntry(EntryId id, boolean owner, boolean write, boolean visible) {
        this.id = id;
        this.owner = owner;
        this.write = write;
        this.visible = visible;
    }

    public PermissionEntry match(EntryId id) {
        if (this.id.match(id)) {
            return this;
        }
        return null;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(30);
        s.append(this.id.toString());
        s.append('|');
        s.append(this.owner ? (char)'o' : '-');
        s.append(this.write ? "rw" : "r-");
        s.append(this.visible ? (char)'v' : '-');
        return s.toString();
    }

    public static String getPermissionType(byte permission) {
        switch (permission) {
            case 1: {
                return "OWNER";
            }
            case 2: {
                return "VISIBLE";
            }
            case 0: {
                return "WRITE";
            }
        }
        return "";
    }
}

