/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.activitygroup;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.activity.activitygroup.IGroupRequestAdvisor;
import org.eclipse.papyrus.diagram.activity.activitygroup.editpolicy.notifiers.GroupNotifyingEditPolicy;
import org.eclipse.papyrus.diagram.activity.activitygroup.editpolicy.notifiers.IGroupNotifier;
import org.eclipse.papyrus.diagram.activity.activitygroup.predicates.DescendantsFilter;
import org.eclipse.papyrus.diagram.activity.activitygroup.predicates.DescendantsFilterIGroupNotifier;
import org.eclipse.papyrus.diagram.activity.activitygroup.request.IGroupRequest;
import org.eclipse.papyrus.diagram.activity.activitygroup.request.SetDeferredRequest;
import org.eclipse.papyrus.diagram.activity.activitygroup.utils.DebugUtils;
import org.eclipse.papyrus.diagram.activity.activitygroup.utils.Utils;
import org.eclipse.papyrus.diagram.activity.commands.DeferredSetValueCommand;
import org.eclipse.papyrus.diagram.activity.edit.part.ActivityGroup.IGroupCompartmentEditPart;
import org.eclipse.papyrus.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.diagram.common.commands.RemoveValueCommand;
import org.eclipse.papyrus.diagram.common.commands.RemoveValueRequest;
import org.eclipse.papyrus.log.LogHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupRequestAdvisor
implements IGroupRequestAdvisor {
    private static final String UNABLE_TO_GET_THE_INTIAL_TARGET_REQUEST_BOUNDS = "Unable to get the intial target request bounds";
    private static final String GROUP_FRAMEWORK_GRAPHICAL_PARENT = "GroupFramework_GraphicalParent";
    private static final String CHILDREN_REFERENCES_ARE = " ---- Children references are : ---- ";
    private static final String ALL_PARENT_REFERENCES_ARE = " ---- All parent references are : ---- ";
    private Multimap<EObject, IGroupNotifier> listenners = ArrayListMultimap.create();
    private static LogHelper log = new LogHelper((Plugin)UMLDiagramEditorPlugin.getInstance());

    public static GroupRequestAdvisor getInstance() {
        return SingletonHolder.instance;
    }

    private GroupRequestAdvisor() {
    }

    @Override
    public void addListenner(EObject eObject, IGroupNotifier editpolicy) {
        this.listenners.put((Object)eObject, (Object)editpolicy);
    }

    @Override
    public void removeListenner(IGroupNotifier editpolicy) {
        if (editpolicy == null) {
            return;
        }
        Iterator iterator = this.listenners.entries().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!editpolicy.equals(entry.getValue())) continue;
            iterator.remove();
        }
    }

    @Override
    public ICommand notifyGroupFramework(IGroupRequest request) {
        if (DebugUtils.isDebugging()) {
            log.debug("***********************BEGIN : Group Request Advisor***********************************");
        }
        CompositeCommand cc = new CompositeCommand("Global command from GroupRequestAdvisor");
        this.fillRequestWithAllPossibleParent(request);
        this.fillRequestWithAllPossibleChildren(request);
        Object elementAdapter = request.getTargetElement().getAdapter(EObject.class);
        if (elementAdapter instanceof EObject) {
            this.handleSemanticChildren(request, cc, (EObject)elementAdapter);
            this.handleSemanticParents(request, cc, (EObject)elementAdapter);
        }
        if (DebugUtils.isDebugging()) {
            log.debug("***********************END : Group Request Advisor***********************************");
        }
        if (cc != null && !cc.isEmpty()) {
            return cc;
        }
        return null;
    }

    protected void handleSemanticChildren(IGroupRequest request, CompositeCommand cc, EObject targetElement) {
        List<EObject> graphicalChildren = this.handleGraphicalChildren(request, cc);
        for (Map.Entry oldChildrenEntry : Utils.getOldChildren(request).entries()) {
            Multimap<EReference, EObject> allActualChildren = request.getChildrenEReferenceMap();
            EReference ref = (EReference)oldChildrenEntry.getKey();
            if (ref == null || allActualChildren.containsEntry(oldChildrenEntry.getValue(), (Object)ref)) continue;
            EReference eOpposite = ref.getEOpposite();
            if (graphicalChildren.contains(oldChildrenEntry.getValue()) || eOpposite == null || eOpposite.isContainment() || ref.isContainment()) continue;
            RemoveValueRequest rmVa = new RemoveValueRequest(targetElement, (EStructuralFeature)ref, Collections.singletonList((EObject)oldChildrenEntry.getValue()));
            RemoveValueCommand rmCmd = new RemoveValueCommand(rmVa);
            cc.compose((IUndoableOperation)rmCmd);
        }
        for (Map.Entry entry : request.getChildrenEReferenceMap().entries()) {
            EReference ref = (EReference)entry.getKey();
            if (ref == null) continue;
            EReference eOpposite = ref.getEOpposite();
            if (graphicalChildren.contains(entry.getValue()) || eOpposite == null || eOpposite.isContainment()) continue;
            SetDeferredRequest setRq = new SetDeferredRequest(request.getHostRequest().getEditingDomain(), request.getTargetElement(), (EStructuralFeature)ref, entry.getValue());
            DeferredSetValueCommand setCmd = new DeferredSetValueCommand(setRq);
            cc.compose((IUndoableOperation)setCmd);
        }
    }

    protected List<EObject> handleGraphicalChildren(IGroupRequest request, CompositeCommand cc) {
        ArrayList<EObject> graphicalChildren = new ArrayList<EObject>();
        Object targetEditPart = request.getTargetElement().getAdapter(IGraphicalEditPart.class);
        IGraphicalEditPart compartementEditPart = null;
        if (targetEditPart instanceof IGroupCompartmentEditPart) {
            compartementEditPart = (IGraphicalEditPart)targetEditPart;
        } else if (targetEditPart instanceof IGraphicalEditPart) {
            compartementEditPart = request.getNodeDescpitor().getCompartmentPartFromView((IGraphicalEditPart)targetEditPart);
        }
        if (compartementEditPart != null) {
            Iterable policies = Iterables.transform((Iterable)compartementEditPart.getChildren(), (Function)new Function<IGraphicalEditPart, GroupNotifyingEditPolicy>(){

                public GroupNotifyingEditPolicy apply(IGraphicalEditPart from) {
                    EditPolicy editPolicy = from.getEditPolicy((Object)"GroupFramework_NotifyingEditPolicy");
                    if (editPolicy instanceof GroupNotifyingEditPolicy) {
                        return (GroupNotifyingEditPolicy)editPolicy;
                    }
                    return null;
                }
            });
            for (GroupNotifyingEditPolicy p : policies) {
                if (p == null) continue;
                if (DebugUtils.isDebugging()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("+++ Work for child ");
                    stringBuilder.append(Utils.getCorrectLabel(p.getEObject()));
                    stringBuilder.append(" +++");
                    DebugUtils.getLog().debug(stringBuilder.toString());
                }
                ChangeBoundsRequest auxChReq = Utils.getChangeBoundsRequestCopy((ChangeBoundsRequest)request.getInitialRequest(), (EditPart)p.getHostEditPart());
                auxChReq.getExtendedData().put(GROUP_FRAMEWORK_GRAPHICAL_PARENT, compartementEditPart.resolveSemanticElement());
                graphicalChildren.add(p.getEObject());
                Command childCommand = p.getCommand((Request)auxChReq);
                if (childCommand == null || !childCommand.canExecute()) continue;
                cc.compose((IUndoableOperation)new CommandProxy(childCommand));
            }
        }
        return graphicalChildren;
    }

    protected void handleSemanticParents(IGroupRequest request, CompositeCommand cc, Object elementAdapter) {
        EObject targetElement = (EObject)elementAdapter;
        for (Map.Entry entry : Utils.getOldParents(request).entries()) {
            EReference eOpposite;
            Multimap<EReference, EObject> allActualParent = request.getParentEReferenceMap();
            EReference ref = (EReference)entry.getKey();
            if (ref == null || allActualParent.containsEntry(entry.getValue(), (Object)ref) || (eOpposite = ref.getEOpposite()) == null || eOpposite.isContainment()) continue;
            RemoveValueRequest rmVa = new RemoveValueRequest(targetElement, (EStructuralFeature)ref, Collections.singletonList((EObject)entry.getValue()));
            RemoveValueCommand rmCmd = new RemoveValueCommand(rmVa);
            cc.compose((IUndoableOperation)rmCmd);
        }
        for (Map.Entry entry : request.getParentEReferenceMap().entries()) {
            EReference eOpposite;
            EReference ref = (EReference)entry.getKey();
            if (ref == null || (eOpposite = ref.getEOpposite()) == null || eOpposite.isContainment() || ref.isContainment()) continue;
            SetDeferredRequest setRq = new SetDeferredRequest(request.getHostRequest().getEditingDomain(), request.getTargetElement(), (EStructuralFeature)ref, entry.getValue());
            DeferredSetValueCommand setCmd = new DeferredSetValueCommand(setRq);
            cc.compose((IUndoableOperation)setCmd);
        }
    }

    protected Multimap<EReference, IGroupNotifier> fillRequestWithAllPossibleChildren(IGroupRequest request) {
        Multimap<EReference, IGroupNotifier> result = this.fillReqestWithReferendedElement(request, false, false);
        DebugUtils.displayMultipmapDebug(CHILDREN_REFERENCES_ARE, request.getChildrenEReferenceMap());
        return result;
    }

    public EObject getPossibleModelParent(IGroupRequest request) {
        Multimap<EReference, IGroupNotifier> parentsMap = this.fillReqestWithReferendedElement(request, true, true);
        ArrayList parents = Lists.newArrayList((Iterable)parentsMap.values());
        Collections.sort(parents);
        if (!parents.isEmpty()) {
            return ((IGroupNotifier)parents.get(0)).getEObject();
        }
        return request.getHostRequest().resolveSemanticElement();
    }

    protected void getReferenceElements(IGroupRequest request, Rectangle newBounds, List<EReference> references, Multimap<EReference, EObject> eReferenceMapToFillInRequest, Multimap<EReference, IGroupNotifier> result, boolean include, boolean containementOnly) {
        Iterable activeListeners = Iterables.filter((Iterable)this.listenners.values(), (Predicate)new ActiveListener(this.getCurrentlyDisplayedDiagram(request)));
        for (IGroupNotifier input : activeListeners) {
            Object adapter;
            EObject inputEObject = input.getEObject();
            if (inputEObject == null || inputEObject.equals(adapter = request.getTargetElement().getAdapter(EObject.class))) continue;
            EReference refenceFounded = null;
            for (EReference ref : references) {
                EClass eoBjectType;
                EClass refType = ref.getEReferenceType();
                if (!refType.isSuperTypeOf(eoBjectType = inputEObject.eClass())) continue;
                refenceFounded = ref;
                break;
            }
            if (refenceFounded == null || (!include || !input.includes(newBounds)) && (include || !input.isIncludedIn(newBounds)) || containementOnly && refenceFounded.getEOpposite() != null && !refenceFounded.getEOpposite().isContainment()) continue;
            eReferenceMapToFillInRequest.put(refenceFounded, (Object)inputEObject);
            result.put((Object)refenceFounded, (Object)input);
        }
    }

    protected Diagram getCurrentlyDisplayedDiagram(IGroupRequest request) {
        Object m;
        IGraphicalEditPart graph = request.getHostRequest();
        if (graph != null && (m = graph.getModel()) instanceof View) {
            View v = (View)m;
            return v.getDiagram();
        }
        throw new RuntimeException("Unable to get the current diagram displayed");
    }

    protected Multimap<EReference, IGroupNotifier> fillRequestWithAllPossibleParent(IGroupRequest request) {
        Multimap<EReference, IGroupNotifier> result = this.fillReqestWithReferendedElement(request, true, false);
        DebugUtils.displayMultipmapDebug(ALL_PARENT_REFERENCES_ARE, request.getParentEReferenceMap());
        return result;
    }

    protected Multimap<EReference, IGroupNotifier> fillReqestWithReferendedElement(IGroupRequest request, boolean lookingForParent, boolean onlyContainment) {
        Rectangle newBounds = GroupRequestAdvisor.getInitalTargetRequestNewBounds(request);
        List<EReference> references = null;
        references = lookingForParent ? request.getNodeDescpitor().getParentReferences() : request.getNodeDescpitor().getChildrenReferences();
        ArrayListMultimap auxResult = ArrayListMultimap.create();
        ArrayListMultimap result = ArrayListMultimap.create();
        ArrayListMultimap parentEReferenceMap = ArrayListMultimap.create();
        this.getReferenceElements(request, newBounds, references, (Multimap<EReference, EObject>)parentEReferenceMap, (Multimap<EReference, IGroupNotifier>)auxResult, lookingForParent, onlyContainment);
        for (EReference ref : parentEReferenceMap.keySet()) {
            Collection filteredCollection = Collections2.filter((Collection)parentEReferenceMap.get((Object)ref), (Predicate)new DescendantsFilter(parentEReferenceMap.values()));
            request.getParentEReferenceMap().putAll((Object)ref, (Iterable)filteredCollection);
        }
        for (EReference ref : auxResult.keySet()) {
            Iterable resultCollection = Iterables.filter((Iterable)auxResult.get((Object)ref), (Predicate)new DescendantsFilterIGroupNotifier(auxResult.values()));
            result.putAll((Object)ref, resultCollection);
        }
        return result;
    }

    public static Rectangle getInitalTargetRequestNewBounds(IGroupRequest request) {
        Request initialRequest = request.getInitialRequest();
        if (initialRequest instanceof ChangeBoundsRequest) {
            return Utils.getAbslotueRequestBounds((ChangeBoundsRequest)initialRequest, request.getHostRequest());
        }
        if (initialRequest instanceof CreateViewRequest) {
            return Utils.getAbslotueRequestBounds((CreateViewRequest)initialRequest);
        }
        throw new RuntimeException(UNABLE_TO_GET_THE_INTIAL_TARGET_REQUEST_BOUNDS);
    }

    /* synthetic */ GroupRequestAdvisor(GroupRequestAdvisor groupRequestAdvisor) {
        this();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActiveListener
    implements Predicate<IGroupNotifier> {
        private Diagram currentDiagramDisplayed;

        public ActiveListener(Diagram currentDiagramDisplayed) {
            this.currentDiagramDisplayed = currentDiagramDisplayed;
            Assert.isNotNull((Object)currentDiagramDisplayed);
        }

        public boolean apply(IGroupNotifier input) {
            View primaryView;
            IGraphicalEditPart host = input.getHostEditPart();
            if (host != null && (primaryView = host.getPrimaryView()) != null) {
                return this.currentDiagramDisplayed.equals(primaryView.getDiagram());
            }
            return false;
        }
    }

    private static class SingletonHolder {
        public static final GroupRequestAdvisor instance = new GroupRequestAdvisor(null);

        private SingletonHolder() {
        }
    }
}

