/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.activitygroup.editpolicy;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SemanticCreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.diagram.ui.requests.RefreshConnectionsRequest;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.activity.activitygroup.ContainerNodeDescriptorRegistry;
import org.eclipse.papyrus.diagram.activity.activitygroup.GroupRequestAdvisor;
import org.eclipse.papyrus.diagram.activity.activitygroup.IContainerNodeDescriptor;
import org.eclipse.papyrus.diagram.activity.activitygroup.request.AbstractGroupRequest;
import org.eclipse.papyrus.diagram.activity.activitygroup.request.IGroupRequest;
import org.eclipse.papyrus.diagram.activity.activitygroup.utils.Utils;
import org.eclipse.uml2.uml.UMLPackage;

public class GroupCreationEditPolicy
extends CreationEditPolicy {
    private IContainerNodeDescriptor groupDescriptor;

    public GroupCreationEditPolicy(IContainerNodeDescriptor groupDescriptor) {
        this.groupDescriptor = groupDescriptor;
    }

    protected IContainerNodeDescriptor getGroupDescriptor() {
        return this.groupDescriptor;
    }

    protected Command getReparentCommand(ChangeBoundsRequest request) {
        Iterator editParts = request.getEditParts().iterator();
        View container = (View)this.getHost().getAdapter(View.class);
        EObject context = container == null ? null : ViewUtil.resolveSemanticElement((View)container);
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
        while (editParts.hasNext()) {
            View view;
            EditPart ep = (EditPart)editParts.next();
            if (ep instanceof LabelEditPart) continue;
            if (ep instanceof GroupEditPart) {
                cc.compose((IUndoableOperation)this.getReparentGroupCommand((GroupEditPart)ep));
            }
            if ((view = (View)ep.getAdapter(View.class)) == null) continue;
            EObject semantic = ViewUtil.resolveSemanticElement((View)view);
            if (semantic == null) {
                cc.compose((IUndoableOperation)this.getReparentViewCommand((IGraphicalEditPart)ep));
                continue;
            }
            if (context == null) continue;
            if (this.shouldReparentModel(semantic, context)) {
                cc.compose((IUndoableOperation)this.getReparentCommand((IGraphicalEditPart)ep));
                continue;
            }
            if (!this.shouldGraphicalyReparent(semantic, context)) continue;
            cc.compose((IUndoableOperation)this.getReparentViewCommand((IGraphicalEditPart)ep));
        }
        return cc.isEmpty() ? null : new ICommandProxy(cc.reduce());
    }

    protected boolean isVisuallyContained(IGraphicalEditPart ep, ChangeBoundsRequest request) {
        Rectangle hostBounds = Utils.getAbsoluteBounds((IGraphicalEditPart)this.getHost());
        Rectangle ndeBounds = Utils.getAbslotueRequestBounds(request, ep);
        return hostBounds.contains(ndeBounds);
    }

    protected boolean shouldReparentModel(EObject element, EObject newContext) {
        EReference feature = PackageUtil.findFeature((EClass)newContext.eClass(), (EClass)element.eClass());
        return feature != null && feature.isContainment() && this.shouldReparent(element, newContext) && !this.isSameContainer(element, newContext);
    }

    protected boolean shouldGraphicalyReparent(EObject element, EObject newContext) {
        EReference feature = GroupCreationEditPolicy.findFeatureWhichReference(newContext.eClass(), element.eClass());
        return feature != null && !feature.isContainment() && this.shouldReparent(element, newContext);
    }

    protected static EReference findFeatureWhichReference(EClass container, EClass eClass) {
        for (EReference reference : container.getEAllReferences()) {
            if (!PackageUtil.canReference((EClass)container, (EReference)reference, (EClass)eClass)) continue;
            return reference;
        }
        return null;
    }

    protected static boolean canReference(EClass class1, EClass class2) {
        for (EReference reference : class1.getEAllReferences()) {
            EClass eType;
            if (reference.isContainment() || !(eType = (EClass)reference.getEType()).equals(class2) && !eType.isSuperTypeOf(class2)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldReparent(EObject element, EObject newContext) {
        return element != null && element != newContext && !this.isContainedIn(element, newContext);
    }

    protected boolean isSameContainer(EObject element, EObject newContext) {
        return element.eContainer() == newContext;
    }

    private boolean isContainedIn(EObject element, EObject newContext) {
        EObject container = newContext.eContainer();
        while (container != null) {
            if (container.equals(element)) {
                return true;
            }
            container = container.eContainer();
        }
        return false;
    }

    public EditPart getTargetEditPart(Request request) {
        ChangeBoundsRequest chRequest;
        List editParts;
        if (request instanceof ChangeBoundsRequest && (editParts = (chRequest = (ChangeBoundsRequest)request).getEditParts()) != null) {
            for (Object p : editParts) {
                if (!(p instanceof IGraphicalEditPart)) continue;
                IGraphicalEditPart graphEditPart = (IGraphicalEditPart)p;
                if (this.isVisuallyContained(graphEditPart, chRequest)) {
                    return this.getHost();
                }
                return ((IGraphicalEditPart)this.getHost()).getTopGraphicEditPart().getParent();
            }
        }
        return super.getTargetEditPart(request);
    }

    protected Command getCreateElementAndViewCommand(CreateViewAndElementRequest request) {
        Command createElementCommand;
        CreateElementRequestAdapter requestAdapter = request.getViewAndElementDescriptor().getCreateElementRequestAdapter();
        CreateElementRequest createElementRequest = (CreateElementRequest)requestAdapter.getAdapter(CreateElementRequest.class);
        this.tryToFindModelParentFromGroupFramework(createElementRequest, new AbstractGroupRequest((IGraphicalEditPart)this.getHost(), (Request)request, request.getViewAndElementDescriptor().getElementAdapter(), ContainerNodeDescriptorRegistry.getInstance().getContainerNodeDescriptor(UMLPackage.Literals.ACTIVITY_NODE)){

            public IGroupRequest.GroupRequestType getGroupRequestType() {
                return IGroupRequest.GroupRequestType.CREATION;
            }
        });
        if (createElementRequest.getContainer() == null) {
            View view = (View)this.getHost().getModel();
            EObject hostElement = ViewUtil.resolveSemanticElement((View)view);
            if (hostElement == null && view.getElement() == null) {
                hostElement = view;
            }
            if (hostElement == null) {
                return null;
            }
            createElementRequest.setContainer(hostElement);
        }
        if ((createElementCommand = this.getHost().getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)((CreateElementRequest)requestAdapter.getAdapter(CreateElementRequest.class)), request.getExtendedData()))) == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (!createElementCommand.canExecute()) {
            return createElementCommand;
        }
        SemanticCreateCommand semanticCommand = new SemanticCreateCommand(requestAdapter, createElementCommand);
        Command viewCommand = this.getCreateCommand((CreateViewRequest)request);
        Command refreshConnectionCommand = this.getHost().getCommand((Request)new RefreshConnectionsRequest((List)request.getNewObject()));
        CompositeCommand cc = new CompositeCommand(semanticCommand.getLabel());
        cc.compose((IUndoableOperation)semanticCommand);
        cc.compose((IUndoableOperation)new CommandProxy(viewCommand));
        if (refreshConnectionCommand != null) {
            cc.compose((IUndoableOperation)new CommandProxy(refreshConnectionCommand));
        }
        return new ICommandProxy((ICommand)cc);
    }

    protected void tryToFindModelParentFromGroupFramework(CreateElementRequest createElementRequest, IGroupRequest request) {
        EObject parent = GroupRequestAdvisor.getInstance().getPossibleModelParent(request);
        if (parent != null) {
            createElementRequest.setContainer(parent);
        }
    }
}

