/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.activitygroup.request;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.papyrus.diagram.activity.activitygroup.utils.DebugUtils;
import org.eclipse.papyrus.diagram.activity.part.UMLDiagramEditorPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeferredMoveRequest
extends MoveRequest {
    private IAdaptable targetContainer;
    private Map<IAdaptable, Object> iAdaptableToMove;
    private Map<EObject, Object> elementsToMove;
    private Class<? extends EObject> classToCast;

    public DeferredMoveRequest(TransactionalEditingDomain editingDomain, IAdaptable targetContainer, List<? extends IAdaptable> elementsToMove, Class<? extends EObject> classToCast) {
        super(editingDomain, null, elementsToMove);
        this.targetContainer = targetContainer;
        this.iAdaptableToMove = new HashMap<IAdaptable, Object>();
        this.classToCast = classToCast;
        Iterator<? extends IAdaptable> i = elementsToMove.iterator();
        while (i.hasNext()) {
            this.iAdaptableToMove.put(i.next(), null);
        }
    }

    public DeferredMoveRequest(TransactionalEditingDomain editingDomain, IAdaptable targetContainer, EReference targetFeature, IAdaptable elementToMove, Class<? extends EObject> classToCast) {
        super(editingDomain, null, targetFeature, null);
        this.targetContainer = targetContainer;
        this.iAdaptableToMove = new HashMap<IAdaptable, Object>();
        this.classToCast = classToCast;
        this.iAdaptableToMove.put(elementToMove, targetFeature);
    }

    public DeferredMoveRequest(TransactionalEditingDomain editingDomain, IAdaptable targetContainer, Map<IAdaptable, Object> elementsToMove, Class<? extends EObject> classToCast) {
        super(editingDomain, null, elementsToMove);
        this.targetContainer = targetContainer;
        this.classToCast = classToCast;
        this.iAdaptableToMove = elementsToMove;
    }

    public Map getElementsToMove() {
        if (this.elementsToMove == null) {
            this.elementsToMove = new HashMap<EObject, Object>(this.iAdaptableToMove.size());
            for (Map.Entry<IAdaptable, Object> entry : this.iAdaptableToMove.entrySet()) {
                IAdaptable key = entry.getKey();
                Object object = key.getAdapter(this.classToCast);
                if (object instanceof EObject) {
                    this.elementsToMove.put((EObject)object, entry.getValue());
                    continue;
                }
                if (!UMLDiagramEditorPlugin.getInstance().isDebugging()) continue;
                DebugUtils.getLog().warn("Unable to retrieve the Eobject to move (" + key + ")");
            }
        }
        return this.elementsToMove;
    }

    public EObject getTargetContainer() {
        Object object = this.targetContainer.getAdapter(this.classToCast);
        if (object instanceof EObject) {
            return (EObject)object;
        }
        if (UMLDiagramEditorPlugin.getInstance().isDebugging()) {
            DebugUtils.getLog().warn("Unable to retrieve the Eobject of the target container (" + this.targetContainer + ")");
        }
        return null;
    }
}

