/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.draw2d;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.diagram.activity.draw2d.CenteredColumnConstraint;

public class CenteredColumnLayout
extends StackLayout {
    private static final Rectangle RECTANGLE = new Rectangle();
    private static final int MARGIN = 5;
    private Map<IFigure, CenteredColumnConstraint> constraints = new HashMap<IFigure, CenteredColumnConstraint>();

    public void layout(IFigure figure) {
        Rectangle rect = figure.getClientArea();
        int centerX = rect.x + rect.width / 2;
        int yAxe = rect.y;
        int availableExtraHeight = rect.height;
        int numberOfFillChildren = 0;
        LinkedList<IFigure> orderedFigures = new LinkedList<IFigure>();
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension prefSize = child.getPreferredSize(-1, -1);
            availableExtraHeight -= prefSize.height + 5;
            if (this.constraints.get(child) != null && this.constraints.get(child).isAvailableSpaceFilled()) {
                ++numberOfFillChildren;
            }
            if (!this.constraints.containsKey(child)) {
                this.constraints.put(child, null);
            }
            orderedFigures.add(i, child);
            ++i;
        }
        int fillExtraHeight = 0;
        if (numberOfFillChildren > 0) {
            fillExtraHeight = availableExtraHeight / numberOfFillChildren;
        }
        for (IFigure childF : orderedFigures) {
            boolean fill = this.constraints.get(childF).isAvailableSpaceFilled();
            Dimension prefSize = childF.getPreferredSize(-1, -1);
            CenteredColumnLayout.RECTANGLE.x = centerX - prefSize.width / 2;
            CenteredColumnLayout.RECTANGLE.y = yAxe;
            CenteredColumnLayout.RECTANGLE.width = prefSize.width;
            CenteredColumnLayout.RECTANGLE.height = !fill ? prefSize.height + 5 : prefSize.height + 5 + fillExtraHeight;
            childF.setBounds(RECTANGLE);
            yAxe += CenteredColumnLayout.RECTANGLE.height;
        }
    }

    public void setConstraint(IFigure child, Object constraint) {
        if (constraint instanceof CenteredColumnConstraint) {
            this.constraints.put(child, (CenteredColumnConstraint)constraint);
        }
        super.setConstraint(child, constraint);
    }

    public Object getConstraint(IFigure child) {
        return this.constraints.get(child);
    }

    protected Dimension calculateMinimumSize(IFigure figure, int wHint, int hHint) {
        if (wHint > -1) {
            wHint = Math.max(0, wHint - figure.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - figure.getInsets().getHeight());
        }
        Dimension d = new Dimension();
        List children = figure.getChildren();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            if (!this.isObservingVisibility() || child.isVisible()) {
                Dimension childSize = child.getMinimumSize(wHint, hHint);
                d.height += childSize.height;
                d.width = Math.max(d.width, childSize.width);
            }
            ++i;
        }
        d.expand(figure.getInsets().getWidth(), figure.getInsets().getHeight());
        d.union(this.getBorderPreferredSize(figure));
        return d;
    }
}

