/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.edit.commands;

import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.diagram.activity.edit.commands.util.CreateCommandUtil;
import org.eclipse.papyrus.diagram.activity.providers.ElementInitializers;
import org.eclipse.papyrus.diagram.common.service.palette.IFeatureSetterAspectAction;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class CallOperationActionCreateCommand
extends EditElementCommand {
    private EClass eClass = null;
    private EObject eObject = null;

    public CallOperationActionCreateCommand(CreateElementRequest req, EObject eObject) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
        this.eObject = eObject;
        this.eClass = eObject != null ? eObject.eClass() : null;
    }

    public static CallOperationActionCreateCommand create(CreateElementRequest req, EObject eObject) {
        return new CallOperationActionCreateCommand(req, eObject);
    }

    public CallOperationActionCreateCommand(CreateElementRequest req) {
        super(req.getLabel(), null, (IEditCommandRequest)req);
    }

    protected EObject getElementToEdit() {
        EObject container = ((CreateElementRequest)this.getRequest()).getContainer();
        if (container instanceof View) {
            container = ((View)container).getElement();
        }
        if (container != null) {
            return container;
        }
        return this.eObject;
    }

    public boolean canExecute() {
        return CreateCommandUtil.canCreateNode(this.getRequest(), this.getElementToEdit());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        Activity parentActivity = null;
        EObject parent = this.getElementToEdit();
        while (parent != null && parentActivity == null) {
            if (parent instanceof Activity) {
                parentActivity = (Activity)parent;
            }
            parent = parent.eContainer();
        }
        CallOperationAction newElement = UMLFactory.eINSTANCE.createCallOperationAction();
        if (!CreateCommandUtil.setNodeParents((ActivityNode)newElement, this.getRequest(), this.getElementToEdit())) {
            return CommandResult.newCancelledCommandResult();
        }
        ElementInitializers.getInstance().init_CallOperationAction_3010(newElement);
        this.doConfigure(newElement, monitor, info);
        ((CreateElementRequest)this.getRequest()).setNewElement((EObject)newElement);
        return CommandResult.newOKCommandResult((Object)newElement);
    }

    private boolean isOperationAlreadyManaged() {
        IEditCommandRequest aRequest = this.getRequest();
        Map map = aRequest.getParameters();
        return !IFeatureSetterAspectAction.IFeatureSetterAspectActionUtil.areFeaturesManaged((IEditCommandRequest)this.getRequest(), (EStructuralFeature)UMLPackage.Literals.CALL_OPERATION_ACTION__OPERATION);
    }

    protected void doConfigure(CallOperationAction newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = ((CreateElementRequest)this.getRequest()).getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(((CreateElementRequest)this.getRequest()).getClientContext());
        configureRequest.addParameters(this.getRequest().getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }
}

