/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.diagram.activity.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.ExceptionHandler;
import org.eclipse.uml2.uml.ExecutableNode;
import org.eclipse.uml2.uml.ObjectNode;

public class ExceptionHandlerReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ExceptionHandlerReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof ExceptionHandler)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof ExecutableNode) || !(this.newEnd instanceof ExecutableNode)) {
            return false;
        }
        ObjectNode target = this.getLink().getExceptionInput();
        if (!(this.getLink().eContainer() instanceof ExecutableNode)) {
            return false;
        }
        ExecutableNode container = (ExecutableNode)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistExceptionHandler_4005(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ObjectNode) || !(this.newEnd instanceof ObjectNode)) {
            return false;
        }
        ExecutableNode source = this.getLink().getProtectedNode();
        if (!(this.getLink().eContainer() instanceof ExecutableNode)) {
            return false;
        }
        ExecutableNode container = (ExecutableNode)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistExceptionHandler_4005(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setProtectedNode(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setExceptionInput(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected ExceptionHandler getLink() {
        return (ExceptionHandler)this.getElementToEdit();
    }

    protected ExecutableNode getOldSource() {
        return (ExecutableNode)this.oldEnd;
    }

    protected ExecutableNode getNewSource() {
        return (ExecutableNode)this.newEnd;
    }

    protected ObjectNode getOldTarget() {
        return (ObjectNode)this.oldEnd;
    }

    protected ObjectNode getNewTarget() {
        return (ObjectNode)this.newEnd;
    }
}

