/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.edit.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.uml2.uml.NamedElement;

public class WarningAndLinkDialog
extends MessageDialog {
    private NamedElement element;
    private String label;
    private boolean allowNavigation;

    public WarningAndLinkDialog(Shell parentShell, String dialogTitle, String dialogMessage, NamedElement linkElement, String linkLabel) {
        super(parentShell, dialogTitle, null, dialogMessage, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.element = linkElement;
        this.label = linkLabel;
        this.allowNavigation = true;
    }

    protected WarningAndLinkDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, NamedElement linkElement, String linkLabel, boolean closeAfterNavigation) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.element = linkElement;
        this.label = linkLabel;
        this.allowNavigation = closeAfterNavigation;
    }

    protected Control createCustomArea(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Hyperlink hyperLink = toolkit.createHyperlink(parent, this.label, 4);
        hyperLink.setBackground(parent.getBackground());
        hyperLink.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        if (this.allowNavigation) {
            hyperLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    WarningAndLinkDialog.this.navigateToElement();
                    WarningAndLinkDialog.this.okPressed();
                }
            });
        }
        return hyperLink;
    }

    protected void navigateToElement() {
        IViewReference[] views;
        IMultiDiagramEditor editor = EditorUtils.getMultiDiagramEditor();
        IViewReference[] iViewReferenceArray = views = editor.getSite().getPage().getViewReferences();
        int n = views.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference view = iViewReferenceArray[n2];
            IWorkbenchPart part = view.getPart(false);
            if (part instanceof CommonNavigator) {
                CommonNavigator navigator = (CommonNavigator)part;
                navigator.setFocus();
                navigator.selectReveal((ISelection)new StructuredSelection((Object)this.element));
            }
            ++n2;
        }
    }
}

