/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.edit.helper.advice;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.papyrus.diagram.common.commands.DestroyElementPapyrusCommand;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;

public class ActivityNodeEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        EObject eObject = request.getElementToDestroy();
        if (eObject instanceof ActivityNode) {
            ActivityNode activityNode = (ActivityNode)eObject;
            EList incomings = activityNode.getIncomings();
            EList outgoings = activityNode.getOutgoings();
            HashSet edges = Sets.newHashSet();
            if (incomings != null && !incomings.isEmpty()) {
                edges.addAll(incomings);
            }
            if (outgoings != null && !outgoings.isEmpty()) {
                edges.addAll(outgoings);
            }
            if (!edges.isEmpty()) {
                CompositeCommand cc = new CompositeCommand("Detele Incomings and outgoings edges from activity node");
                for (ActivityEdge e : edges) {
                    DestroyElementRequest destroyRequest = new DestroyElementRequest((EObject)e, false);
                    DestroyElementPapyrusCommand destroyCommand = new DestroyElementPapyrusCommand(destroyRequest);
                    if (destroyCommand == null || !destroyCommand.canExecute()) continue;
                    cc.compose((IUndoableOperation)destroyCommand);
                }
                return cc;
            }
        }
        return super.getAfterDestroyDependentsCommand(request);
    }
}

