/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.handlers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.core.modelsetquery.ModelSetQuery;
import org.eclipse.papyrus.diagram.activity.handlers.AbstractSynchronizePinsAndParameters;
import org.eclipse.papyrus.diagram.activity.handlers.SynchronizePinsParametersHandler;
import org.eclipse.papyrus.ui.toolbox.notification.NotificationRunnable;
import org.eclipse.papyrus.ui.toolbox.notification.Type;
import org.eclipse.papyrus.ui.toolbox.notification.builders.IContext;
import org.eclipse.papyrus.ui.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.CallAction;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalSynchronizePinsParametersHandler
extends AbstractSynchronizePinsAndParameters {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            Object obj = structuredSelection.getFirstElement();
            EObject element = null;
            if (obj instanceof IAdaptable) {
                element = (EObject)((IAdaptable)obj).getAdapter(EObject.class);
                if (element instanceof View) {
                    element = ((View)element).getElement();
                }
                if (element instanceof Package) {
                    Package pack = (Package)element;
                    final Collection objectsOfType = ModelSetQuery.getObjectsOfType((EObject)pack, (EClassifier)UMLPackage.Literals.CALL_ACTION);
                    new NotificationBuilder().setAsynchronous(false).setType(Type.WARNING).setHTML(true).setMessage(this.getCallActionToSync(objectsOfType)).addAction(new NotificationRunnable(){

                        public void run(IContext context) {
                            for (EObject ca : objectsOfType) {
                                EditingDomain editingDomain;
                                if (!(ca instanceof CallAction) || (editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)ca)).isReadOnly(ca.eResource())) continue;
                                SynchronizePinsParametersHandler.syncCallAction((CallAction)ca);
                            }
                        }

                        public String getLabel() {
                            return "Synchronize";
                        }
                    }).addAction(new NotificationRunnable(){

                        public void run(IContext context) {
                        }

                        public String getLabel() {
                            return "Cancel";
                        }
                    }).run();
                }
            }
        }
        return null;
    }

    protected String getCallActionToSync(Collection<EObject> objectsOfType) {
        StringBuilder builder = new StringBuilder("<form><p>The following Call Actions will be synchronized : </p>");
        ArrayList<EObject> readOnlyresource = new ArrayList<EObject>();
        for (EObject e : objectsOfType) {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)e);
            boolean isReadOnly = editingDomain.isReadOnly(e.eResource());
            if (!isReadOnly) {
                if (!(e instanceof NamedElement)) continue;
                builder.append("<li>");
                builder.append(((NamedElement)e).getQualifiedName());
                builder.append("</li>");
                continue;
            }
            readOnlyresource.add(e);
        }
        if (!readOnlyresource.isEmpty()) {
            builder.append("<p> </p><p>The following Call Actions will not be synchronized because the are is read only mode :</p>");
            for (EObject e : readOnlyresource) {
                if (!(e instanceof NamedElement)) continue;
                builder.append("<li>").append(((NamedElement)e).getQualifiedName()).append("</li>");
            }
        }
        builder.append("</form>");
        return builder.toString();
    }
}

