/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.handlers;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.commands.wrappers.EMFtoGEFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.diagram.activity.commands.CreatePinToParameterLinkEAnnotation;
import org.eclipse.papyrus.diagram.activity.handlers.AbstractSynchronizePinsAndParameters;
import org.eclipse.papyrus.diagram.activity.helper.PinAndParameterSynchronizer;
import org.eclipse.papyrus.diagram.activity.helper.datastructure.LinkPinToParameter;
import org.eclipse.papyrus.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.diagram.activity.providers.UMLMarkerNavigationProvider;
import org.eclipse.papyrus.diagram.common.commands.DestroyElementPapyrusCommand;
import org.eclipse.papyrus.ui.toolbox.notification.Type;
import org.eclipse.papyrus.ui.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallAction;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizePinsParametersHandler
extends AbstractSynchronizePinsAndParameters {
    private static final String SYNCHRONIZE_PINS_AND_PARAMETERS = "Synchronize pins and parameters";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            Object obj = structuredSelection.getFirstElement();
            EObject element = null;
            if (obj instanceof IAdaptable) {
                element = (EObject)((IAdaptable)obj).getAdapter(EObject.class);
                if (element instanceof View) {
                    element = ((View)element).getElement();
                }
                if (element instanceof CallAction) {
                    CallAction callAction = (CallAction)element;
                    SynchronizePinsParametersHandler.syncCallAction(callAction);
                }
            }
        }
        return null;
    }

    public static void syncCallAction(CallAction callAction) {
        if (!SynchronizePinsParametersHandler.isAccessible(callAction)) {
            SynchronizePinsParametersHandler.createNotification(SYNCHRONIZE_PINS_AND_PARAMETERS, "Unable to synchronize pins on " + callAction.getQualifiedName() + " : the ressource is unreachable", Type.WARNING);
            return;
        }
        SynchronizePinsParametersHandler.matchPinsAndParams(callAction);
        if (SynchronizePinsParametersHandler.isUpToDate(callAction)) {
            SynchronizePinsParametersHandler.createNotification(SYNCHRONIZE_PINS_AND_PARAMETERS, "The call action " + callAction.getQualifiedName() + " is up to date", Type.INFO);
        } else {
            SynchronizePinsParametersHandler.syncCallActionWhenOutdated(callAction);
        }
        SynchronizePinsParametersHandler.renamePins(callAction);
    }

    private static void renamePins(final CallAction callAction) {
        AbstractTransactionalCommand renamePinsCommand = new AbstractTransactionalCommand(EditorUtils.getTransactionalEditingDomain(), "renaming pins", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Iterable allPins = Iterables.concat((Iterable)callAction.getResults(), (Iterable)callAction.getArguments());
                Behavior behaviorStructural = null;
                if (callAction instanceof CallBehaviorAction) {
                    behaviorStructural = ((CallBehaviorAction)callAction).getBehavior();
                } else if (callAction instanceof CallOperationAction) {
                    behaviorStructural = ((CallOperationAction)callAction).getOperation();
                }
                XMIResource xmiResource = PinAndParameterSynchronizer.getXMIResource((Element)behaviorStructural);
                for (Pin pin : allPins) {
                    Parameter parameter = PinAndParameterSynchronizer.getLinkedParemeter(pin, xmiResource);
                    if (parameter == null) continue;
                    String paramName = parameter.getName();
                    pin.setName(paramName);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        ICommandProxy renamePinsCommandProxy = new ICommandProxy((ICommand)renamePinsCommand);
        SynchronizePinsParametersHandler.executeCommand((org.eclipse.gef.commands.Command)renamePinsCommandProxy, (EObject)callAction);
    }

    private static void matchPinsAndParams(CallAction callAction) {
        ArrayList inputPins = Lists.newArrayList((Iterable)callAction.getArguments());
        ArrayList outputPins = Lists.newArrayList((Iterable)callAction.getResults());
        CompoundCommand linkingPinsAndParamsCommand = new CompoundCommand();
        List<Parameter> callActionParams = SynchronizePinsParametersHandler.getParametersFromCallAction(callAction);
        HashMap<Integer, Parameter> inputParameters = new HashMap<Integer, Parameter>();
        HashMap<Integer, Parameter> outputParameters = new HashMap<Integer, Parameter>();
        PinAndParameterSynchronizer.splitParameters(callActionParams, Collections.<Parameter>emptyList(), inputParameters, outputParameters);
        SynchronizePinsParametersHandler.matchPinsAndParams(inputPins, inputParameters, linkingPinsAndParamsCommand);
        SynchronizePinsParametersHandler.matchPinsAndParams(outputPins, outputParameters, linkingPinsAndParamsCommand);
        SynchronizePinsParametersHandler.executeCommand((org.eclipse.gef.commands.Command)new EMFtoGEFCommandWrapper((Command)linkingPinsAndParamsCommand), (EObject)callAction);
    }

    private static void matchPinsAndParams(List<? extends Pin> pins, Map<Integer, Parameter> parameters, CompoundCommand globalCmd) {
        int pinIndex = 0;
        while (pinIndex < pins.size()) {
            Pin pin = pins.get(pinIndex);
            if (SynchronizePinsParametersHandler.lacksPinToParameterLink(pin)) {
                Parameter paramWithSameIndex = parameters.get(pinIndex);
                boolean foundMatchingParam = false;
                if (paramWithSameIndex != null && pin.getType() == paramWithSameIndex.getType()) {
                    LinkPinToParameter link = new LinkPinToParameter(pin, paramWithSameIndex);
                    CreatePinToParameterLinkEAnnotation linkCommand = new CreatePinToParameterLinkEAnnotation(EditorUtils.getTransactionalEditingDomain(), link);
                    globalCmd.append((Command)linkCommand);
                    foundMatchingParam = true;
                    SynchronizePinsParametersHandler.createNotification(SYNCHRONIZE_PINS_AND_PARAMETERS, "The pin " + pin.getQualifiedName() + " " + "has been linked to the parameter " + paramWithSameIndex.getQualifiedName(), Type.INFO);
                }
                if (!foundMatchingParam) {
                    SynchronizePinsParametersHandler.createNotification(SYNCHRONIZE_PINS_AND_PARAMETERS, "The pin " + pin.getQualifiedName() + " will be deleted, along with its edges", Type.WARNING);
                }
            }
            ++pinIndex;
        }
    }

    private static boolean lacksPinToParameterLink(Pin pin) {
        return pin.getEAnnotation("PinToParameterLink") == null;
    }

    private static List<Parameter> getParametersFromCallAction(CallAction callAction) {
        EList result = null;
        if (callAction instanceof CallBehaviorAction) {
            result = ((CallBehaviorAction)callAction).getBehavior().getOwnedParameters();
        } else if (callAction instanceof CallOperationAction) {
            result = ((CallOperationAction)callAction).getOperation().getOwnedParameters();
        }
        return result;
    }

    private static void syncCallActionWhenOutdated(CallAction callAction) {
        CompoundCommand cmd = PinAndParameterSynchronizer.getResetPinsCmd(callAction);
        Behavior behaviorStructural = null;
        if (callAction instanceof CallBehaviorAction) {
            behaviorStructural = ((CallBehaviorAction)callAction).getBehavior();
        } else if (callAction instanceof CallOperationAction) {
            behaviorStructural = ((CallOperationAction)callAction).getOperation();
        }
        XMIResource xmiResource = PinAndParameterSynchronizer.getXMIResource((Element)behaviorStructural);
        if (!cmd.isEmpty() && cmd.canExecute()) {
            Iterable<Object> outgoing = Collections.emptyList();
            Iterable<Object> incoming = Collections.emptyList();
            for (Pin p : callAction.getResults()) {
                if (SynchronizePinsParametersHandler.isUpToDate(p, xmiResource)) continue;
                outgoing = Iterables.concat(outgoing, (Iterable)p.getOutgoings());
            }
            for (Pin p : callAction.getArguments()) {
                if (SynchronizePinsParametersHandler.isUpToDate(p, xmiResource)) continue;
                incoming = Iterables.concat(incoming, (Iterable)p.getIncomings());
            }
            HashSet newHashSet = Sets.newHashSet((Iterable)Iterables.concat(outgoing, incoming));
            DeleteActivityEdgeDialog dialog = new DeleteActivityEdgeDialog(new Shell(), newHashSet, callAction);
            if (dialog.open() == 0) {
                IFile target = callAction.eResource() != null ? WorkspaceSynchronizer.getFile((Resource)callAction.eResource()) : null;
                for (ActivityEdge activityEdge : dialog.getEgdesToDelete()) {
                    DestroyElementPapyrusCommand detryCmd;
                    EditingDomain editingDomain;
                    if (!newHashSet.isEmpty()) {
                        UMLItemProviderAdapterFactory umlAdapterFactory = new UMLItemProviderAdapterFactory();
                        IItemLabelProvider edgeLabelProvider = (IItemLabelProvider)umlAdapterFactory.adapt((Notifier)activityEdge, IItemLabelProvider.class);
                        IItemLabelProvider callActionLabelProvider = (IItemLabelProvider)umlAdapterFactory.adapt((Notifier)callAction, IItemLabelProvider.class);
                        UMLMarkerNavigationProvider.addMarker(target, activityEdge.eResource().getURIFragment((EObject)activityEdge), EMFCoreUtil.getQualifiedName((EObject)callAction, (boolean)true), "The edge " + edgeLabelProvider.getText((Object)activityEdge) + " has been deleted since " + callActionLabelProvider.getText((Object)callAction) + " has been synchronized", 2);
                    }
                    if (!((editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)activityEdge)) instanceof TransactionalEditingDomain) || (detryCmd = new DestroyElementPapyrusCommand(new DestroyElementRequest((EObject)activityEdge, false))) == null || !detryCmd.canExecute()) continue;
                    ((TransactionalEditingDomain)editingDomain).getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)detryCmd));
                }
                SynchronizePinsParametersHandler.executeCommand((org.eclipse.gef.commands.Command)new EMFtoGEFCommandWrapper((Command)cmd), (EObject)callAction);
                SynchronizePinsParametersHandler.createNotification(SYNCHRONIZE_PINS_AND_PARAMETERS, "The call action " + callAction.getQualifiedName() + " has been synchronized", Type.INFO);
            }
        }
    }

    public static void createNotification(String title, String text, Type type) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.papyrus.ui.toolbox.notification.view.PapyrusNotificationView");
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        new NotificationBuilder().setAsynchronous(true).setTemporary(false).setTitle(title).setMessage(text).setType(type).run();
    }

    private static boolean isUpToDate(CallAction callAction) {
        Parameter pa;
        ArrayList operationArgument = null;
        ArrayList callActionArgument = Lists.newArrayList((Iterable)callAction.getArguments());
        ArrayList callActionResult = Lists.newArrayList((Iterable)callAction.getResults());
        XMIResource xmiResource = null;
        if (callAction instanceof CallOperationAction) {
            CallOperationAction callOperationAction = (CallOperationAction)callAction;
            Operation operation = callOperationAction.getOperation();
            xmiResource = operation != null ? PinAndParameterSynchronizer.getXMIResource((Element)operation) : null;
            operationArgument = Lists.newArrayList((Iterable)callOperationAction.getOperation().getOwnedParameters());
        } else if (callAction instanceof CallBehaviorAction) {
            CallBehaviorAction callBehaviorAction = (CallBehaviorAction)callAction;
            Behavior behavior = callBehaviorAction.getBehavior();
            xmiResource = behavior != null ? PinAndParameterSynchronizer.getXMIResource((Element)behavior) : null;
            operationArgument = Lists.newArrayList((Iterable)callBehaviorAction.getBehavior().getOwnedParameters());
        }
        if (operationArgument == null) {
            return true;
        }
        final HashSet<Parameter> operationArgumentFound = new HashSet<Parameter>();
        for (InputPin p : callActionArgument) {
            if (!SynchronizePinsParametersHandler.isUpToDate((Pin)p, xmiResource)) {
                return false;
            }
            pa = PinAndParameterSynchronizer.getLinkedParemeter((Pin)p, xmiResource);
            operationArgumentFound.add(pa);
        }
        for (InputPin p : callActionResult) {
            if (!SynchronizePinsParametersHandler.isUpToDate((Pin)p, xmiResource)) {
                return false;
            }
            pa = PinAndParameterSynchronizer.getLinkedParemeter((Pin)p, xmiResource);
            operationArgumentFound.add(pa);
        }
        Iterable intersectionBetweenPinParamsAndAllParams = Iterables.filter((Iterable)operationArgument, (Predicate)new Predicate<Parameter>(){

            public boolean apply(Parameter input) {
                return !operationArgumentFound.contains(input);
            }
        });
        return Iterables.size((Iterable)intersectionBetweenPinParamsAndAllParams) == 0;
    }

    public static boolean isUpToDate(Pin pin, XMIResource xmiResource) {
        boolean result = false;
        Parameter pa = PinAndParameterSynchronizer.getLinkedParemeter(pin, xmiResource);
        if (pa != null) {
            if (pin.getType() != null) {
                result = pin.getType().isCompatibleWith((ParameterableElement)pa.getType());
            } else {
                boolean bl = result = pin.getType() == pa.getType();
            }
            if (pin instanceof OutputPin) {
                boolean directionIsOut = pa.getDirection().getValue() == 2;
                directionIsOut |= pa.getDirection().getValue() == 1;
                result &= (directionIsOut |= pa.getDirection().getValue() == 3);
            } else if (pin instanceof InputPin) {
                boolean directionIsIn = pa.getDirection().getValue() == 0;
                result &= (directionIsIn |= pa.getDirection().getValue() == 1);
            }
        }
        return result;
    }

    public static boolean isAccessible(CallAction callAction) {
        boolean result = false;
        Behavior targetedBehavior = null;
        if (callAction instanceof CallBehaviorAction) {
            CallBehaviorAction cba = (CallBehaviorAction)callAction;
            targetedBehavior = cba.getBehavior();
        } else if (callAction instanceof CallOperationAction) {
            targetedBehavior = ((CallOperationAction)callAction).getOperation();
        }
        if (targetedBehavior != null) {
            result = !targetedBehavior.eIsProxy();
        }
        return result;
    }

    protected static void executeCommand(final org.eclipse.gef.commands.Command cmd, EObject eObject) {
        Map<String, Boolean> options = null;
        options = Collections.singletonMap("unprotected", Boolean.TRUE);
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
        if (editingDomain instanceof TransactionalEditingDomain) {
            AbstractEMFOperation operation = new AbstractEMFOperation((TransactionalEditingDomain)editingDomain, "", options){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    cmd.execute();
                    return Status.OK_STATUS;
                }
            };
            try {
                operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                Log.warning((Plugin)UMLDiagramEditorPlugin.getInstance(), (int)9, (String)"executeCommand", (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActivityEdgeDialog
    extends MessageDialog {
        private Iterable<ActivityEdge> egdes;
        private CallAction callAction;

        public DeleteActivityEdgeDialog(Shell parentShell, Iterable<ActivityEdge> egdes, CallAction callAction) {
            super(parentShell, SynchronizePinsParametersHandler.SYNCHRONIZE_PINS_AND_PARAMETERS, SynchronizePinsParametersHandler.getIcon(), "", 4, new String[]{"Synchronize", "Cancel"}, 0);
            this.egdes = egdes;
            this.callAction = callAction;
            this.message = this.getEdgeListString();
        }

        private String getEdgeListString() {
            UMLItemProviderAdapterFactory t = new UMLItemProviderAdapterFactory();
            IItemLabelProvider provider = (IItemLabelProvider)t.adapt((Notifier)this.callAction, IItemLabelProvider.class);
            StringBuilder builder = new StringBuilder("If you synchronize " + provider.getText((Object)this.callAction) + " the following edges will be deleted : \n ");
            for (ActivityEdge e : this.egdes) {
                provider = (IItemLabelProvider)t.adapt((Notifier)e, IItemLabelProvider.class);
                builder.append(provider.getText((Object)e)).append(" \n");
            }
            return builder.toString();
        }

        public int open() {
            if (this.egdes.iterator().hasNext()) {
                return super.open();
            }
            return 0;
        }

        public Iterable<ActivityEdge> getEgdesToDelete() {
            return this.egdes;
        }
    }
}

