/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbstractPointListShape;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.PolylineShape;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Shape;

public class ActivityFigureDrawer {
    private static final List<Point> TRIANGLE_FIGURE = new ArrayList<Point>(3);
    private static final Point TRIANGLE_FIGURE_SIZE;
    private static final List<Point> RAKE_FIGURE;
    private static final Point RAKE_FIGURE_TRANSLATION;
    private static final List<Point> RIGHT_PIN_ARROW_FIGURE;
    private static final List<Point> LEFT_PIN_ARROW_FIGURE;
    private static final List<Point> UP_PIN_ARROW_FIGURE;
    private static final List<Point> DOWN_PIN_ARROW_FIGURE;
    private static final Point PIN_ARROW_FIGURE_SIZE;

    static {
        TRIANGLE_FIGURE.add(new Point(0, 5));
        TRIANGLE_FIGURE.add(new Point(5, 5));
        TRIANGLE_FIGURE.add(new Point(3, 0));
        TRIANGLE_FIGURE_SIZE = new Point(5, 5);
        RAKE_FIGURE = new ArrayList<Point>(8);
        RAKE_FIGURE.add(new Point(0, 10));
        RAKE_FIGURE.add(new Point(0, 4));
        RAKE_FIGURE.add(new Point(5, 4));
        RAKE_FIGURE.add(new Point(5, 0));
        RAKE_FIGURE.add(new Point(5, 10));
        RAKE_FIGURE.add(new Point(5, 4));
        RAKE_FIGURE.add(new Point(10, 4));
        RAKE_FIGURE.add(new Point(10, 10));
        RAKE_FIGURE_TRANSLATION = new Point(-16, -12);
        RIGHT_PIN_ARROW_FIGURE = new ArrayList<Point>(8);
        RIGHT_PIN_ARROW_FIGURE.add(new Point(4, 2));
        RIGHT_PIN_ARROW_FIGURE.add(new Point(7, 4));
        RIGHT_PIN_ARROW_FIGURE.add(new Point(1, 4));
        RIGHT_PIN_ARROW_FIGURE.add(new Point(7, 4));
        RIGHT_PIN_ARROW_FIGURE.add(new Point(4, 6));
        LEFT_PIN_ARROW_FIGURE = new ArrayList<Point>(8);
        LEFT_PIN_ARROW_FIGURE.add(new Point(4, 2));
        LEFT_PIN_ARROW_FIGURE.add(new Point(1, 4));
        LEFT_PIN_ARROW_FIGURE.add(new Point(7, 4));
        LEFT_PIN_ARROW_FIGURE.add(new Point(1, 4));
        LEFT_PIN_ARROW_FIGURE.add(new Point(4, 6));
        UP_PIN_ARROW_FIGURE = new ArrayList<Point>(8);
        UP_PIN_ARROW_FIGURE.add(new Point(2, 4));
        UP_PIN_ARROW_FIGURE.add(new Point(4, 1));
        UP_PIN_ARROW_FIGURE.add(new Point(4, 7));
        UP_PIN_ARROW_FIGURE.add(new Point(4, 1));
        UP_PIN_ARROW_FIGURE.add(new Point(6, 4));
        DOWN_PIN_ARROW_FIGURE = new ArrayList<Point>(8);
        DOWN_PIN_ARROW_FIGURE.add(new Point(2, 4));
        DOWN_PIN_ARROW_FIGURE.add(new Point(4, 7));
        DOWN_PIN_ARROW_FIGURE.add(new Point(4, 1));
        DOWN_PIN_ARROW_FIGURE.add(new Point(4, 7));
        DOWN_PIN_ARROW_FIGURE.add(new Point(6, 4));
        PIN_ARROW_FIGURE_SIZE = new Point(8, 8);
    }

    public static int getOppositeDirection(int direction) {
        switch (direction) {
            case 1: {
                return 4;
            }
            case 16: {
                return 8;
            }
            case 4: {
                return 1;
            }
            case 8: {
                return 16;
            }
        }
        return 0;
    }

    public static void redrawTriangle(Polygon triangle, IMapMode iMapMode, Dimension parentDimension) {
        triangle.removeAllPoints();
        double xScale = parentDimension.preciseWidth() / (double)ActivityFigureDrawer.TRIANGLE_FIGURE_SIZE.x;
        double yScale = parentDimension.preciseHeight() / (double)ActivityFigureDrawer.TRIANGLE_FIGURE_SIZE.y;
        for (Point refPoint : TRIANGLE_FIGURE) {
            Point translatedPoint = new Point(refPoint).scale(xScale, yScale);
            iMapMode.DPtoLP((Translatable)translatedPoint);
            triangle.addPoint(translatedPoint);
        }
    }

    public static void redrawRake(AbstractPointListShape rake, IMapMode iMapMode, Dimension parentDimension) {
        rake.removeAllPoints();
        Point translationPoint = new Point();
        if (!(rake instanceof PolylineShape)) {
            new Point(RAKE_FIGURE_TRANSLATION);
            translationPoint.translate(parentDimension);
        }
        for (Point refPoint : RAKE_FIGURE) {
            Point translatedPoint = new Point(refPoint).translate(translationPoint);
            iMapMode.DPtoLP((Translatable)translatedPoint);
            rake.addPoint(translatedPoint);
        }
        if (rake instanceof PolylineShape) {
            Point loc = rake.getParent().getBounds().getLocation().getCopy().translate(parentDimension).translate(RAKE_FIGURE_TRANSLATION);
            Rectangle b = new Rectangle(loc, new Dimension(-ActivityFigureDrawer.RAKE_FIGURE_TRANSLATION.x, -ActivityFigureDrawer.RAKE_FIGURE_TRANSLATION.y));
            ((PolylineShape)rake).setBounds(b);
        }
    }

    public static void redrawPinArrow(AbstractPointListShape arrow, IMapMode iMapMode, Dimension parentDimension, int direction) {
        List<Point> template;
        arrow.removeAllPoints();
        switch (direction) {
            case 1: {
                template = UP_PIN_ARROW_FIGURE;
                break;
            }
            case 4: {
                template = DOWN_PIN_ARROW_FIGURE;
                break;
            }
            case 8: {
                template = LEFT_PIN_ARROW_FIGURE;
                break;
            }
            default: {
                template = RIGHT_PIN_ARROW_FIGURE;
            }
        }
        double xScale = parentDimension.preciseWidth() / (double)ActivityFigureDrawer.PIN_ARROW_FIGURE_SIZE.x;
        double yScale = parentDimension.preciseHeight() / (double)ActivityFigureDrawer.PIN_ARROW_FIGURE_SIZE.y;
        for (Point refPoint : template) {
            Point translatedPoint = new Point(refPoint).scale(xScale, yScale);
            iMapMode.DPtoLP((Translatable)translatedPoint);
            arrow.addPoint(translatedPoint);
        }
        if (arrow instanceof PolylineShape) {
            ((PolylineShape)arrow).setBounds(arrow.getParent().getBounds());
        }
    }

    public static void undrawFigure(AbstractPointListShape figure) {
        figure.removeAllPoints();
    }

    public static Dimension getNodeSize(AbstractGraphicalEditPart editPart, Notification dimensionChangeEvent) {
        Shape shape;
        Bounds bounds = null;
        if (dimensionChangeEvent != null && dimensionChangeEvent.getNotifier() instanceof Bounds) {
            bounds = (Bounds)dimensionChangeEvent.getNotifier();
        } else if (editPart.getModel() instanceof Shape && (shape = (Shape)editPart.getModel()).getLayoutConstraint() instanceof Bounds) {
            bounds = (Bounds)shape.getLayoutConstraint();
        }
        Dimension size = null;
        if (bounds != null) {
            size = new Dimension(bounds.getWidth(), bounds.getHeight());
        }
        if (size == null || size.isEmpty()) {
            Dimension preferredSize = editPart.getFigure().getPreferredSize(size.width, size.height);
            if (size.width <= 0) {
                size.width = preferredSize.width;
            }
            if (size.height <= 0) {
                size.height = preferredSize.height;
            }
        }
        return size;
    }
}

