/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.IBorderItemLocator;
import org.eclipse.papyrus.diagram.common.locator.AdvancedBorderItemLocator;

public class ActivityParameterNodePositionLocator
extends AdvancedBorderItemLocator
implements IBorderItemLocator {
    public static final int EXTRA_BORDER_DEFAULT_OFFSET = 8;
    public static final int DEFAULT_PIN_SIZE = 16;
    protected int borderItemOffset = 10;

    public ActivityParameterNodePositionLocator(IFigure parentFigure) {
        super(parentFigure);
    }

    public ActivityParameterNodePositionLocator(IFigure borderItem, IFigure parentFigure, Rectangle constraint) {
        super(borderItem, parentFigure, constraint);
    }

    public ActivityParameterNodePositionLocator(IFigure parentFigure, int preferredSide) {
        super(parentFigure, preferredSide);
    }

    public Rectangle getValidLocation(Rectangle proposedLocation, IFigure borderItem) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        int side = ActivityParameterNodePositionLocator.findClosestSideOfParent(proposedLocation, this.getParentBorder());
        Point newTopLeft = this.locateOnBorder(realLocation.getTopLeft(), side, 0, borderItem);
        realLocation.setLocation(newTopLeft);
        return realLocation;
    }

    public static int findClosestSideOfParent(Rectangle proposedLocation, Rectangle parentBorder) {
        int side = AdvancedBorderItemLocator.findClosestSideOfParent((Rectangle)proposedLocation, (Rectangle)parentBorder);
        if (side == 1) {
            Point parentCenter = parentBorder.getCenter();
            Point childCenter = proposedLocation.getCenter();
            if (childCenter.x < parentCenter.x) {
                return 8;
            }
            return 16;
        }
        return side;
    }

    protected Point locateOnParent(Point suggestedLocation, int suggestedSide, IFigure borderItem) {
        Rectangle bounds = this.getParentBorder();
        int parentFigureWidth = bounds.width;
        int parentFigureHeight = bounds.height;
        int parentFigureX = bounds.x;
        int parentFigureY = bounds.y;
        Dimension borderItemSize = this.getSize(borderItem);
        int newX = suggestedLocation.x;
        int newY = suggestedLocation.y;
        int westX = parentFigureX + this.getBorderItemOffset().width;
        int eastX = parentFigureX + parentFigureWidth - this.getBorderItemOffset().width - borderItemSize.width;
        int southY = parentFigureY + parentFigureHeight - this.getBorderItemOffset().height - borderItemSize.height;
        int northY = parentFigureY + this.getBorderItemOffset().height + borderItemSize.height;
        if (suggestedSide == 8) {
            if (suggestedLocation.x != westX) {
                newX = westX;
            }
            if (suggestedLocation.y < borderItemSize.height) {
                newY = northY + borderItemSize.height;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = southY - borderItemSize.height;
            }
        } else if (suggestedSide == 16) {
            if (suggestedLocation.x != eastX) {
                newX = eastX;
            }
            if (suggestedLocation.y < borderItemSize.height) {
                newY = northY + borderItemSize.height;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = southY - borderItemSize.height;
            }
        } else if (suggestedSide == 4) {
            if (suggestedLocation.y != southY) {
                newY = southY;
            }
            if (suggestedLocation.x < bounds.getBottomLeft().x) {
                newX = westX + borderItemSize.width;
            } else if (suggestedLocation.x > bounds.getBottomRight().x - borderItemSize.width) {
                newX = eastX - borderItemSize.width;
            }
        } else {
            if (suggestedLocation.x != westX) {
                newX = westX;
            }
            if (suggestedLocation.y < bounds.getTopLeft().y) {
                newY = northY + borderItemSize.height;
            } else if (suggestedLocation.y > bounds.getBottomLeft().y - borderItemSize.height) {
                newY = southY - borderItemSize.height;
            }
        }
        return new Point(newX, newY);
    }

    public void relocate(IFigure borderItem) {
        Dimension size = this.getSize(borderItem);
        Rectangle rectSuggested = this.getConstraint().getCopy();
        if (rectSuggested.getTopLeft().x == 0 && rectSuggested.getTopLeft().y == 0) {
            rectSuggested.setLocation(this.getPreferredLocation(borderItem));
        } else {
            rectSuggested.setLocation(rectSuggested.getLocation().translate(this.getParentBorder().getTopLeft()));
        }
        rectSuggested.setSize(size);
        Rectangle validLocation = this.getValidLocation(rectSuggested, borderItem);
        borderItem.setBounds(validLocation);
        this.setCurrentSideOfParent(ActivityParameterNodePositionLocator.findClosestSideOfParent(borderItem.getBounds(), this.getParentBorder()));
    }

    protected Point getPreferredLocation(int side, IFigure borderItem) {
        return super.getPreferredLocation(side, borderItem);
    }

    public Rectangle getPreferredLocation(Rectangle proposedLocation) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        Rectangle parentRec = this.getParentFigure().getBounds().getCopy();
        int xMin = parentRec.x - this.borderItemOffset;
        int xMax = parentRec.x - this.borderItemOffset + parentRec.width;
        int yMin = parentRec.y - this.borderItemOffset;
        int yMax = parentRec.y - this.borderItemOffset + parentRec.height;
        if (realLocation.x < xMin) {
            realLocation.x = xMin;
        }
        if (realLocation.x > xMax) {
            realLocation.x = xMax;
        }
        if (realLocation.y < yMin) {
            realLocation.y = yMin;
        }
        if (realLocation.y > yMax) {
            realLocation.y = yMax;
        }
        if (realLocation.y != yMin && realLocation.y != yMax && realLocation.x != xMin && realLocation.x != xMax) {
            realLocation.x = realLocation.x <= xMin + parentRec.width / 2 ? xMin : xMax;
        }
        return realLocation;
    }
}

