/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.diagram.activity.parser.custom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.papyrus.diagram.activity.parsers.MessageFormatParser;
import org.eclipse.papyrus.diagram.common.commands.SetValueSpecificationValueCommand;
import org.eclipse.papyrus.umlutils.ValueSpecificationUtil;
import org.eclipse.uml2.uml.JoinNode;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinSpecParser
extends MessageFormatParser
implements ISemanticParser {
    private static final String JOIN_SPEC_FORMAT = "{joinSpec = %s}";

    public JoinSpecParser(EAttribute[] features, EAttribute[] editableFeatures) {
        super(features, editableFeatures);
    }

    public JoinSpecParser(EAttribute[] features) {
        super(features);
    }

    public JoinSpecParser() {
        super(new EAttribute[]{UMLPackage.eINSTANCE.getNamedElement_Name()});
    }

    protected EStructuralFeature getEStructuralFeature(Object notification) {
        Object feature;
        EStructuralFeature featureImpl = null;
        if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
            featureImpl = (EStructuralFeature)feature;
        }
        return featureImpl;
    }

    @Override
    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature feature = this.getEStructuralFeature(event);
        return this.isValidFeature(feature);
    }

    @Override
    public String getEditString(IAdaptable adapter, int flags) {
        String value;
        JoinNode join;
        ValueSpecification valueSpec;
        String valueLabel = "";
        Object obj = adapter.getAdapter(EObject.class);
        if (obj instanceof JoinNode && (valueSpec = (join = (JoinNode)obj).getJoinSpec()) != null && (value = ValueSpecificationUtil.getSpecificationValue((ValueSpecification)valueSpec)) != null) {
            valueLabel = value;
        }
        return valueLabel;
    }

    @Override
    public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
        JoinNode join;
        ValueSpecification valueSpec;
        Object obj = adapter.getAdapter(EObject.class);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Object)obj);
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        if (obj instanceof JoinNode && (valueSpec = (join = (JoinNode)obj).getJoinSpec()) != null) {
            CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Set Values");
            command.compose((IUndoableOperation)new CommandProxy((Command)new SetValueSpecificationValueCommand(valueSpec, newString)));
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public String getPrintString(IAdaptable element, int flags) {
        String valueLabel = this.getEditString(element, flags);
        valueLabel = valueLabel.length() == 0 ? " " : String.format(JOIN_SPEC_FORMAT, valueLabel);
        return valueLabel;
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        EStructuralFeature feature = this.getEStructuralFeature(notification);
        return this.isValidFeature(feature);
    }

    public List<?> getSemanticElementsBeingParsed(EObject element) {
        ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
        if (element instanceof JoinNode) {
            JoinNode join = (JoinNode)element;
            semanticElementsBeingParsed.add(join);
            ValueSpecification valueSpec = join.getJoinSpec();
            if (valueSpec != null) {
                semanticElementsBeingParsed.add(valueSpec);
            }
        }
        return semanticElementsBeingParsed;
    }

    private boolean isValidFeature(EStructuralFeature feature) {
        return UMLPackage.eINSTANCE.getNamedElement_Name().equals(feature) || UMLPackage.eINSTANCE.getJoinNode_JoinSpec().equals(feature) || ValueSpecification.class.isAssignableFrom(feature.getContainerClass());
    }
}

