/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.tree.objects;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.profile.Message;
import org.eclipse.papyrus.profile.tree.objects.AppliedStereotypePropertyTreeObject;
import org.eclipse.papyrus.profile.tree.objects.ParentTreeObject;
import org.eclipse.papyrus.profile.tree.objects.StereotypedElementTreeObject;
import org.eclipse.papyrus.profile.utils.Util;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class AppliedStereotypeTreeObject
extends ParentTreeObject {
    protected Stereotype stereotype;

    public AppliedStereotypeTreeObject(StereotypedElementTreeObject parent, Stereotype stereotype) {
        super(parent);
        this.stereotype = stereotype;
    }

    protected void createChildren() {
        for (Property currentProp : this.getStereotype().getAllAttributes()) {
            if (currentProp.getAssociation() != null) {
                if (currentProp.getName().startsWith("base_")) continue;
                this.addChild(new AppliedStereotypePropertyTreeObject(this, currentProp));
                continue;
            }
            this.addChild(new AppliedStereotypePropertyTreeObject(this, currentProp));
        }
    }

    public Stereotype getStereotype() {
        return this.stereotype;
    }

    public void removeMe() {
        Stereotype stereotype = this.getStereotype();
        try {
            this.getParent().removeChild(this);
        }
        catch (IllegalArgumentException requiredEx) {
            Message.warning(String.valueOf(stereotype.getName()) + " stereotype is required for this element");
            requiredEx.printStackTrace();
        }
    }

    public void moveMeUp() {
        StereotypedElementTreeObject rTO = (StereotypedElementTreeObject)this.getParent();
        Stereotype stereotype = this.getStereotype();
        Element root = rTO.getElement();
        BasicEList stereotypes = new BasicEList();
        stereotypes.addAll((Collection)root.getAppliedStereotypes());
        int index = stereotypes.indexOf((Object)stereotype);
        if (index < 1) {
            return;
        }
        stereotypes.move(index - 1, (Object)stereotype);
        Util.reorderStereotypeApplications(root, (EList<Stereotype>)stereotypes);
        this.getParent().moveChildUp(this);
    }

    public void moveMeDown() {
        StereotypedElementTreeObject rTO = (StereotypedElementTreeObject)this.getParent();
        Stereotype stereotype = this.getStereotype();
        Element root = rTO.getElement();
        BasicEList stereotypes = new BasicEList();
        stereotypes.addAll((Collection)root.getAppliedStereotypes());
        int index = stereotypes.indexOf((Object)stereotype);
        if (index == -1 || index >= stereotypes.size() - 1) {
            return;
        }
        stereotypes.move(index + 1, (Object)stereotype);
        Util.reorderStereotypeApplications(root, (EList<Stereotype>)stereotypes);
        this.getParent().moveChildDown(this);
    }
}

