/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.extensionpoints.uml2.profile.FilteredRegisteredProfilesAsLibrarySelectionDialog;
import org.eclipse.papyrus.extensionpoints.uml2.profile.RegisteredProfile;
import org.eclipse.papyrus.extensionpoints.uml2.utils.Util;
import org.eclipse.papyrus.profile.ui.actions.AbstractPackageImportAction;
import org.eclipse.papyrus.profile.ui.dialogs.PackageImportTreeSelectionDialog;
import org.eclipse.papyrus.umlutils.PackageUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.common.edit.command.ChangeCommand;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.UMLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportProfilesAsLibraryFromRepositoryAction
extends AbstractPackageImportAction {
    @Override
    public ChangeCommand getCommand(EditingDomain domain) {
        if (this.command == null) {
            this.command = new ImportProfilesAsLibraryFromRepositoryCommand(domain);
        }
        return this.command;
    }

    protected void importProfiles(RegisteredProfile[] profilesToImport) {
        ResourceSet resourceSet = Util.getResourceSet((EObject)this.selectedElement);
        int i = 0;
        while (i < profilesToImport.length) {
            RegisteredProfile currentProfile = profilesToImport[i];
            URI modelUri = currentProfile.uri;
            Resource modelResource = resourceSet.getResource(modelUri, true);
            PackageImportTreeSelectionDialog eisd = new PackageImportTreeSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Package)modelResource.getContents().get(0));
            int ret = eisd.open();
            if (ret == 0) {
                ArrayList result = eisd.getResult();
                for (Element element : result) {
                    PackageImport ei = UMLFactory.eINSTANCE.createPackageImport();
                    ei.setImportedPackage((Package)element);
                    this.getSelectedElement().getPackageImports().add((Object)ei);
                }
            }
            ++i;
        }
    }

    protected RegisteredProfile[] getAvailableProfiles() {
        ArrayList<RegisteredProfile> profiles = new ArrayList<RegisteredProfile>();
        RegisteredProfile[] allprofiles = RegisteredProfile.getRegisteredProfiles();
        int i = 0;
        while (i < allprofiles.length) {
            RegisteredProfile registeredProfile = allprofiles[i];
            List importedPackageNames = PackageUtil.getImportedPackagesNames((Package)this.getSelectedElement());
            if (!importedPackageNames.contains(registeredProfile.getName())) {
                profiles.add(registeredProfile);
            }
            ++i;
        }
        return profiles.toArray(new RegisteredProfile[profiles.size()]);
    }

    protected Collection<RegisteredProfile> getImportedProfiles() {
        ArrayList<RegisteredProfile> profiles = new ArrayList<RegisteredProfile>();
        RegisteredProfile[] allProfiles = RegisteredProfile.getRegisteredProfiles();
        int i = 0;
        while (i < allProfiles.length) {
            RegisteredProfile registeredProfile = allProfiles[i];
            List importedPackageNames = PackageUtil.getImportedPackagesNames((Package)this.getSelectedElement());
            if (importedPackageNames.contains(registeredProfile.getName())) {
                profiles.add(registeredProfile);
            }
            ++i;
        }
        return profiles;
    }

    public class ImportProfilesAsLibraryFromRepositoryCommand
    extends ChangeCommand {
        public ImportProfilesAsLibraryFromRepositoryCommand(EditingDomain editingDomain) {
            super(editingDomain, new Runnable(){

                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    Object[] allProfiles = RegisteredProfile.getRegisteredProfiles();
                    FilteredRegisteredProfilesAsLibrarySelectionDialog dialog = new FilteredRegisteredProfilesAsLibrarySelectionDialog(shell, true, allProfiles, ImportProfilesAsLibraryFromRepositoryAction.this.getImportedProfiles());
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        List<Object> profilesToImport = Arrays.asList(dialog.getResult());
                        ImportProfilesAsLibraryFromRepositoryAction.this.importProfiles(profilesToImport.toArray(new RegisteredProfile[profilesToImport.size()]));
                    }
                }
            }, "Import Profiles as libraries", "Import Profiles as libraries from Repository");
        }

        public boolean canExecute() {
            return ImportProfilesAsLibraryFromRepositoryAction.this.getSelectedElement() != null;
        }
    }
}

