/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.ui.compositeforview;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.diagram.common.editparts.IUMLEditPart;
import org.eclipse.papyrus.profile.Activator;
import org.eclipse.papyrus.profile.ImageManager;
import org.eclipse.papyrus.profile.tree.DisplayedProfileElementLabelProvider;
import org.eclipse.papyrus.profile.tree.objects.AppliedStereotypePropertyTreeObject;
import org.eclipse.papyrus.profile.tree.objects.AppliedStereotypeTreeObject;
import org.eclipse.papyrus.profile.ui.compositeforview.AppliedStereotypeDisplayComposite;
import org.eclipse.papyrus.profile.ui.compositeforview.IViewComposite;
import org.eclipse.papyrus.profile.ui.compositeforview.ProfileElementWithDisplayContentProvider;
import org.eclipse.papyrus.umlutils.ui.helper.AppliedStereotypeHelper;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class AppearanceForAppliedStereotypeComposite
extends AppliedStereotypeDisplayComposite
implements IViewComposite {
    DisplayedProfileElementLabelProvider displayedProfileElementLabelProvider = new DisplayedProfileElementLabelProvider();
    protected EModelElement diagramElement = null;
    protected Button displayButton;
    protected Button displayButtonQN;
    protected MouseListener displayButtonListener;
    protected ISelection selection;

    public AppearanceForAppliedStereotypeComposite(Composite parent) {
        super(parent);
        this.setBackground(JFaceColors.getBannerBackground((Display)parent.getDisplay()));
        this.displayButtonListener = new DisplayButtonListener();
    }

    public Composite createContent(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createContent(parent, factory);
        this.displayButton = factory.createButton((Composite)this, "", 8);
        this.displayButton.setVisible(true);
        this.displayButton.setImage(ImageManager.IMG_DISPLAY);
        this.displayButton.setToolTipText("Display selected stereotype for the element in the diagram");
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, -5);
        this.displayButton.setLayoutData((Object)data);
        this.displayButton.addMouseListener(this.displayButtonListener);
        this.displayButtonQN = factory.createButton((Composite)this, "", 8);
        this.displayButtonQN.setVisible(true);
        this.displayButtonQN.setImage(ImageManager.IMG_CONSOLEVIEW_WITH_QN);
        this.displayButtonQN.setToolTipText("Display selected stereotypes with their qualified name for the element in the diagram");
        data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.displayButton, -5);
        this.displayButtonQN.setLayoutData((Object)data);
        this.displayButtonQN.addMouseListener(this.displayButtonListener);
        this.label = factory.createCLabel((Composite)this, String.valueOf(this.name) + ":", 0);
        this.label.setLayout((Layout)new FormLayout());
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment((Control)this.displayButtonQN, -35);
        data.top = new FormAttachment(0, 0);
        this.label.setLayoutData((Object)data);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.displayedProfileElementLabelProvider);
        this.tree = this.treeViewer.getTree();
        this.tree.setLayout((Layout)new FormLayout());
        this.tree.setVisible(true);
        data = new FormData(-1, 50);
        data.top = new FormAttachment((Control)this.displayButton, 4);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -4);
        this.tree.setLayoutData((Object)data);
        this.treeViewer.setContentProvider((IContentProvider)new ProfileElementWithDisplayContentProvider(this.diagramElement));
        this.refresh();
        return this;
    }

    public void displayButtonPressed(boolean withQualifiedName) {
        if (this.getTree().getSelection().length < 1) {
            return;
        }
        if (this.getDiagramElement() == null) {
            return;
        }
        TreeItem[] treeSelection = this.getTree().getSelection();
        int i = 0;
        while (i < treeSelection.length) {
            if (treeSelection[i].getData() instanceof AppliedStereotypeTreeObject) {
                Stereotype stereo = ((AppliedStereotypeTreeObject)treeSelection[i].getData()).getStereotype();
                if (treeSelection[i].getImage().equals((Object)ImageManager.IMG_STEREOTYPE)) {
                    this.displayStereotype(stereo);
                    treeSelection[i].setImage(ImageManager.IMG_STEREOTYPEDISPLAYED);
                    if (withQualifiedName) {
                        this.displayStereotypeWithQN(stereo);
                        treeSelection[i].setImage(ImageManager.DISPLAYED_STEREOTYPE_QN);
                    }
                } else {
                    this.removeDisplayStereotype(stereo);
                    treeSelection[i].setImage(ImageManager.IMG_STEREOTYPE);
                }
            } else if (treeSelection[i].getData() instanceof AppliedStereotypePropertyTreeObject) {
                Property prop = ((AppliedStereotypePropertyTreeObject)treeSelection[i].getData()).getProperty();
                if (treeSelection[i].getImage().equals((Object)ImageManager.IMG_DISPLAYEDPROPERTY)) {
                    this.removeStereotypeProperty(((AppliedStereotypeTreeObject)treeSelection[i].getParentItem().getData()).getStereotype(), ((AppliedStereotypePropertyTreeObject)treeSelection[i].getData()).getProperty());
                    treeSelection[i].setImage(ImageManager.IMG_PROPERTY);
                } else {
                    if (!this.isInStereotypeDisplay(((AppliedStereotypeTreeObject)treeSelection[i].getParentItem().getData()).getStereotype()).booleanValue()) {
                        this.displayStereotype(((AppliedStereotypeTreeObject)treeSelection[i].getParentItem().getData()).getStereotype());
                    }
                    this.addStereotypePropertyDisplay(prop, ((AppliedStereotypeTreeObject)treeSelection[i].getParentItem().getData()).getStereotype());
                    treeSelection[i].setImage(ImageManager.IMG_DISPLAYEDPROPERTY);
                }
            }
            ++i;
        }
    }

    protected void addStereotypePropertyDisplay(final Property prop, final Stereotype stereotype) {
        if (this.diagramElement == null) {
            return;
        }
        try {
            this.getDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            String appliedStereotypeListToAdd = String.valueOf(stereotype.getQualifiedName()) + "." + prop.getName();
                            RecordingCommand command = AppliedStereotypeHelper.getAddAppliedStereotypePropertiesCommand((TransactionalEditingDomain)AppearanceForAppliedStereotypeComposite.this.getDomain(), (EModelElement)(this).AppearanceForAppliedStereotypeComposite.this.diagramElement, (String)appliedStereotypeListToAdd);
                            AppearanceForAppliedStereotypeComposite.this.getDomain().getCommandStack().execute((Command)command);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.logException(e);
        }
    }

    public void disposeListeners() {
        if (this.displayButton != null && !this.displayButton.isDisposed()) {
            this.displayButton.removeMouseListener(this.displayButtonListener);
        }
    }

    public EModelElement getDiagramElement() {
        return this.diagramElement;
    }

    public TransactionalEditingDomain getDomain() {
        return EditorUtils.getTransactionalEditingDomain();
    }

    public Element getSelected() {
        Object input = ((IStructuredSelection)this.selection).getFirstElement();
        if (input instanceof IUMLEditPart) {
            return ((IUMLEditPart)input).getUMLElement();
        }
        return null;
    }

    private IUMLEditPart getSelectedEditPart() {
        Object input = ((IStructuredSelection)this.selection).getFirstElement();
        if (input instanceof IUMLEditPart) {
            return (IUMLEditPart)input;
        }
        return null;
    }

    protected Boolean isInStereotypeDisplay(Stereotype st) {
        if (this.getDiagramElement() == null) {
            return false;
        }
        String stereotypeList = AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)this.getDiagramElement());
        if (stereotypeList.contains(st.getQualifiedName())) {
            return true;
        }
        return false;
    }

    public void refresh() {
        if (this.diagramElement != null) {
            this.displayedProfileElementLabelProvider.setDisplayedStereotype(AppliedStereotypeHelper.getStereotypesToDisplay((EModelElement)this.diagramElement));
            this.displayedProfileElementLabelProvider.setDisplayedStereotypeWithQN(AppliedStereotypeHelper.getStereotypesQNToDisplay((EModelElement)this.diagramElement));
            this.displayedProfileElementLabelProvider.setDisplayedProperty(AppliedStereotypeHelper.getAppliedStereotypesPropertiesToDisplay((EModelElement)this.diagramElement));
        }
        super.refresh();
        if (this.diagramElement == null && !this.displayButton.isDisposed()) {
            this.displayButton.setEnabled(false);
            this.displayButton.setToolTipText("Stereotypes can only be displayed for elements with graphical representation. Currently edited element is a non graphical element. (example: an element selected in the outline is not a graphical element)");
        } else {
            this.displayButton.setEnabled(true);
            this.displayButton.setToolTipText("Display selected stereotype for the currently selected element in the diagram");
        }
    }

    protected void removeStereotypeDisplay(Stereotype st) {
        if (this.diagramElement == null) {
            return;
        }
        String presentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)this.diagramElement);
        RecordingCommand command = AppliedStereotypeHelper.getRemoveAppliedStereotypeCommand((TransactionalEditingDomain)this.getDomain(), (EModelElement)this.diagramElement, (String)st.getQualifiedName(), (String)presentationKind);
        this.getDomain().getCommandStack().execute((Command)command);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event == null) {
            return;
        }
    }

    public void setDiagramElement(EModelElement diagramElement) {
        this.diagramElement = diagramElement;
        ((ProfileElementWithDisplayContentProvider)this.treeViewer.getContentProvider()).setDiagramElement(diagramElement);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    protected void displayStereotype(final Stereotype st) {
        if (this.diagramElement == null) {
            return;
        }
        try {
            this.getDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            String presentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)(this).AppearanceForAppliedStereotypeComposite.this.diagramElement);
                            RecordingCommand command = AppliedStereotypeHelper.getAddAppliedStereotypeCommand((TransactionalEditingDomain)AppearanceForAppliedStereotypeComposite.this.getDomain(), (EModelElement)(this).AppearanceForAppliedStereotypeComposite.this.diagramElement, (String)st.getQualifiedName(), (String)presentationKind);
                            AppearanceForAppliedStereotypeComposite.this.getDomain().getCommandStack().execute((Command)command);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.logException(e);
        }
    }

    protected void removeStereotypeProperty(final Stereotype st, final Property property) {
        if (this.diagramElement == null) {
            return;
        }
        try {
            this.getDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            String stringToRemove = String.valueOf(st.getQualifiedName()) + "." + property.getName();
                            RecordingCommand command = AppliedStereotypeHelper.getRemoveAppliedStereotypePropertiesCommand((TransactionalEditingDomain)AppearanceForAppliedStereotypeComposite.this.getDomain(), (EModelElement)(this).AppearanceForAppliedStereotypeComposite.this.diagramElement, (String)stringToRemove);
                            AppearanceForAppliedStereotypeComposite.this.getDomain().getCommandStack().execute((Command)command);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.logException(e);
        }
    }

    protected void displayStereotypeProperties(final Stereotype st) {
        if (this.diagramElement == null) {
            return;
        }
        try {
            this.getDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            String presentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)(this).AppearanceForAppliedStereotypeComposite.this.diagramElement);
                            RecordingCommand command = AppliedStereotypeHelper.getAddAppliedStereotypeCommand((TransactionalEditingDomain)AppearanceForAppliedStereotypeComposite.this.getDomain(), (EModelElement)(this).AppearanceForAppliedStereotypeComposite.this.diagramElement, (String)st.getQualifiedName(), (String)presentationKind);
                            AppearanceForAppliedStereotypeComposite.this.getDomain().getCommandStack().execute((Command)command);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.logException(e);
        }
    }

    protected void displayStereotypeWithQN(final Stereotype st) {
        if (this.diagramElement == null) {
            return;
        }
        try {
            this.getDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            RecordingCommand command = AppliedStereotypeHelper.getAddAppliedStereotypeToDisplayWithQNCommand((TransactionalEditingDomain)AppearanceForAppliedStereotypeComposite.this.getDomain(), (EModelElement)(this).AppearanceForAppliedStereotypeComposite.this.diagramElement, (String)st.getQualifiedName());
                            AppearanceForAppliedStereotypeComposite.this.getDomain().getCommandStack().execute((Command)command);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.logException(e);
        }
    }

    protected void removeDisplayStereotype(final Stereotype st) {
        if (this.diagramElement == null) {
            return;
        }
        try {
            this.getDomain().runExclusive(new Runnable(){

                public void run() {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            String presentationKind = AppliedStereotypeHelper.getAppliedStereotypePresentationKind((EModelElement)(this).AppearanceForAppliedStereotypeComposite.this.diagramElement);
                            RecordingCommand command = AppliedStereotypeHelper.getRemoveAppliedStereotypeCommand((TransactionalEditingDomain)AppearanceForAppliedStereotypeComposite.this.getDomain(), (EModelElement)(this).AppearanceForAppliedStereotypeComposite.this.diagramElement, (String)st.getQualifiedName(), (String)presentationKind);
                            AppearanceForAppliedStereotypeComposite.this.getDomain().getCommandStack().execute((Command)command);
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            Activator.logException(e);
        }
    }

    private class DisplayButtonListener
    implements MouseListener {
        private DisplayButtonListener() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
        }

        public void mouseUp(MouseEvent e) {
            boolean withQualifiedName = false;
            if (e.getSource().equals(AppearanceForAppliedStereotypeComposite.this.displayButtonQN)) {
                withQualifiedName = true;
            }
            TreeItem[] selectedTreeItems = AppearanceForAppliedStereotypeComposite.this.getTree().getSelection();
            AppearanceForAppliedStereotypeComposite.this.displayButtonPressed(withQualifiedName);
            if (!AppearanceForAppliedStereotypeComposite.this.getTree().isDisposed()) {
                AppearanceForAppliedStereotypeComposite.this.getTree().setSelection(selectedTreeItems);
            }
        }
    }
}

