/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.ui.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.papyrus.profile.ui.dialogs.AlphabeticalViewerSorter;
import org.eclipse.papyrus.profile.ui.dialogs.ChooseSetAssistedDialog;
import org.eclipse.papyrus.profile.ui.dialogs.IChooseDialog;
import org.eclipse.papyrus.profile.ui.dialogs.StereotypeLabelProvider;
import org.eclipse.papyrus.profile.ui.dialogs.StereotypeQualifiedLabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Stereotype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChooseSetStereotypeDialog
extends ChooseSetAssistedDialog
implements IChooseDialog {
    private static final String MARTE_HRM = "MARTE::MARTE_DesignModel::HRM::";
    private final StereotypeQualifiedLabelProvider qualifiedLabelProvider = new StereotypeQualifiedLabelProvider();

    public ChooseSetStereotypeDialog(Shell parentShell, Element theElement) {
        super(parentShell, "Applicable Stereotypes: ", "Applied Stereotypes: ");
        this.labelProvider = new StereotypeLabelProvider();
        this.decoratedContentProposalProvider = new StereotypeContentProposalProvider();
        Iterator<Stereotype> stereotypes = theElement.getAppliedStereotypes().iterator();
        while (stereotypes.hasNext()) {
            this.selectedElementList.addElement(stereotypes.next());
        }
        stereotypes = this.filterApplicableStereotypes(theElement);
        while (stereotypes.hasNext()) {
            Stereotype current = stereotypes.next();
            if (this.selectedElementList.contains(current)) continue;
            this.possibleElementList.addElement(current);
        }
    }

    private Iterator<Stereotype> filterApplicableStereotypes(Element elem) {
        Iterator stereotypes = elem.getApplicableStereotypes().iterator();
        BasicEList filteredList = new BasicEList();
        if (elem instanceof Port) {
            if (ChooseSetStereotypeDialog.checkComponentView((EObject)elem).booleanValue()) {
                filteredList.add((Object)elem.getApplicableStereotype("MARTE::MARTE_DesignModel::GCM::ClientServerPort"));
                stereotypes = filteredList.iterator();
            } else if (ChooseSetStereotypeDialog.checkDeploymentView((EObject)elem).booleanValue()) {
                filteredList.add((Object)elem.getApplicableStereotype("MARTE::MARTE_DesignModel::GCM::FlowPort"));
                stereotypes = filteredList.iterator();
            }
        }
        if (elem instanceof Component) {
            if (ChooseSetStereotypeDialog.checkComponentView((EObject)elem).booleanValue()) {
                int i = 0;
                while (i < elem.getApplicableStereotypes().size()) {
                    Stereotype s = (Stereotype)elem.getApplicableStereotypes().get(i);
                    if (!s.getName().equals("StatefulHardware") && !s.getName().equals("StatelessHardware")) {
                        filteredList.add((Object)s);
                    }
                    ++i;
                }
                stereotypes = filteredList.iterator();
            } else if (ChooseSetStereotypeDialog.checkDeploymentView((EObject)elem).booleanValue()) {
                int i = 0;
                while (i < elem.getApplicableStereotypes().size()) {
                    Stereotype s = (Stereotype)elem.getApplicableStereotypes().get(i);
                    if (!(s.getName().equals("StatefulSoftware") || s.getName().equals("StatelessSoftware") || s.getQualifiedName().startsWith(MARTE_HRM))) {
                        filteredList.add((Object)s);
                    }
                    ++i;
                }
                filteredList.add((Object)elem.getApplicableStereotype("MARTE::MARTE_DesignModel::HRM::HwLogical::HwDevice::HWActuator"));
                filteredList.add((Object)elem.getApplicableStereotype("MARTE::MARTE_DesignModel::HRM::HwLogical::HwDevice::HWSensor"));
                filteredList.add((Object)elem.getApplicableStereotype("MARTE::MARTE_DesignModel::HRM::HwLogical::HwStorage::HwMemory::HwCache"));
                filteredList.add((Object)elem.getApplicableStereotype("MARTE::MARTE_DesignModel::HRM::HwLogical::HwComputing::HwASIC"));
                stereotypes = filteredList.iterator();
            }
        }
        if (elem instanceof CallOperationAction) {
            stereotypes = filteredList.iterator();
        }
        return stereotypes;
    }

    private static Boolean checkDeploymentView(EObject currentEObj) {
        Element elem = (Element)currentEObj;
        while (!(elem instanceof Model)) {
            if (elem instanceof Package && elem.getAppliedStereotype("CHESS::Core::CHESSViews::DeploymentView") != null) {
                return true;
            }
            elem = elem.getOwner();
        }
        return false;
    }

    private static Boolean checkComponentView(EObject currentEObj) {
        Element elem = (Element)currentEObj;
        while (!(elem instanceof Model)) {
            if (elem instanceof Package && elem.getAppliedStereotype("CHESS::Core::CHESSViews::ComponentView") != null) {
                return true;
            }
            elem = elem.getOwner();
        }
        return false;
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Control composite = super.createDialogArea(parent);
        this.possibleElementsTable.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.possibleElementsTable, 0x1000000, 0);
        column.setText("Stereotype");
        column.setWidth(150);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseSetStereotypeDialog.this.possibleElementsTableViewer.setSorter((ViewerSorter)new AlphabeticalViewerSorter(0));
            }
        });
        column = new TableColumn(this.possibleElementsTable, 16384, 1);
        column.setText("Information");
        column.setWidth(165);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseSetStereotypeDialog.this.possibleElementsTableViewer.setSorter((ViewerSorter)new AlphabeticalViewerSorter(1));
            }
        });
        this.possibleElementsTableViewer.setSorter((ViewerSorter)new AlphabeticalViewerSorter(0));
        return composite;
    }

    @Override
    protected void runAddElement(String name) {
        Stereotype stereotype = null;
        for (Stereotype element : this.possibleElementList.getElements()) {
            if (!name.equalsIgnoreCase(element.getName()) && !name.equalsIgnoreCase(element.getQualifiedName())) continue;
            stereotype = element;
        }
        if (stereotype != null) {
            this.runActionAdd(stereotype);
        }
    }

    @Override
    protected boolean isSelectableElement(String text) {
        for (Stereotype element : this.possibleElementList.getElements()) {
            if (!text.equalsIgnoreCase(element.getName()) && !text.equalsIgnoreCase(element.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public class StereotypeContentProposalProvider
    extends ChooseSetAssistedDialog.DecoratedContentProposalProvider {
        public ChooseSetAssistedDialog.DecoratedContentProposal[] getProposals(String contents, int position) {
            ArrayList<ChooseSetAssistedDialog.DecoratedContentProposal> proposals = new ArrayList<ChooseSetAssistedDialog.DecoratedContentProposal>();
            if (ChooseSetStereotypeDialog.this.possibleElementList != null) {
                for (Stereotype stereotype : ChooseSetStereotypeDialog.this.possibleElementList.getElements()) {
                    String simpleName = stereotype.getName();
                    String qualifiedName = stereotype.getQualifiedName();
                    if (position < simpleName.length() && contents.substring(0, position).equalsIgnoreCase(simpleName.substring(0, position))) {
                        proposals.add(new ChooseSetAssistedDialog.DecoratedContentProposal(stereotype, ChooseSetStereotypeDialog.this.labelProvider));
                    }
                    if (position >= qualifiedName.length() || !contents.substring(0, position).equalsIgnoreCase(qualifiedName.substring(0, position))) continue;
                    proposals.add(new ChooseSetAssistedDialog.DecoratedContentProposal(stereotype, ChooseSetStereotypeDialog.this.qualifiedLabelProvider));
                }
            }
            Collections.sort(proposals);
            return proposals.toArray(new ChooseSetAssistedDialog.DecoratedContentProposal[proposals.size()]);
        }
    }
}

