/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.ui.dialogs;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.papyrus.profile.Message;
import org.eclipse.papyrus.profile.ui.dialogs.ComboSelectionDialog;
import org.eclipse.papyrus.profile.utils.Util;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Property;

public class InputDialogEnumeration {
    public static final int OK = 0;
    public static final int CANCEL = 1;
    private ComboSelectionDialog iDialog;
    private final String LABEL = "Value:";
    private String[] literals;

    public InputDialogEnumeration(Shell shell, Property property, Object value) {
        this.createLiterals(property);
        if (this.literals != null) {
            String initialValue = this.literals[0];
            EnumerationLiteral eLiteral = null;
            if (value instanceof EnumerationLiteral) {
                eLiteral = (EnumerationLiteral)value;
            } else if (value instanceof EEnumLiteral) {
                EEnumLiteral eEnumLiteral = (EEnumLiteral)value;
                Object tmp = Util.getValueObjectFromString(eEnumLiteral.getName(), property.getType());
                eLiteral = (EnumerationLiteral)tmp;
            } else if (value instanceof Enumerator) {
                String literalString = ((Enumerator)value).getLiteral();
                Object tmp = Util.getValueObjectFromString(literalString, property.getType());
                eLiteral = (EnumerationLiteral)tmp;
            } else if (value == null) {
                initialValue = this.literals[0];
            } else {
                String err = "Value " + value.toString() + " of Property " + property.getName() + " is not an EnumerationLiteral.";
                Message.error(err);
            }
            if (eLiteral != null && eLiteral.isSetName()) {
                initialValue = eLiteral.getQualifiedName();
            }
            this.iDialog = new ComboSelectionDialog(shell, "Value:", this.literals, initialValue);
        }
    }

    public int open() {
        if (this.iDialog != null) {
            return this.iDialog.open();
        }
        return 1;
    }

    public void close() {
        if (this.iDialog != null) {
            this.iDialog.close();
        }
    }

    public Object getValue() {
        if (this.iDialog != null) {
            return this.iDialog.getValue();
        }
        return null;
    }

    public int getSelectionIndex() {
        if (this.iDialog != null) {
            return this.iDialog.indexOfSelection;
        }
        return -1;
    }

    private void createLiterals(Property property) {
        EList tmp = ((Enumeration)property.getType()).getOwnedLiterals();
        String[] enumLiteralNames = Util.getStringArrayFromList((List<Element>)tmp);
        if (enumLiteralNames == null) {
            Message.warning("No literal was found for Enumeration in the model.");
            return;
        }
        this.literals = enumLiteralNames;
    }
}

