/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.ui.dialogs;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.TimeZone;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.papyrus.profile.Activator;
import org.eclipse.papyrus.profile.ImageManager;
import org.eclipse.papyrus.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.papyrus.profile.definition.Version;
import org.eclipse.papyrus.profile.utils.Util;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.uml2.uml.Profile;

public class ProfileDefinitionDialog
extends TitleAreaDialog {
    public static final String PROFILE_DEFINITION = "resources/icons/wizban/NewDefinition.gif";
    protected Text oldVersionText;
    protected Button devVersionButton;
    protected Button releaseVersionButton;
    protected Button majorReleaseVersionButton;
    protected Button customVersionButton;
    protected Text customVersionText;
    protected Profile profileToDefine;
    private Version devVersionValue;
    private Version releaseVersionValue;
    private Version majorReleaseVersionValue;
    private Version oldVersionValue;
    private Version customReleaseVersionValue;
    private Version newVersionValue;
    protected PapyrusDefinitionAnnotation papyrusDefinitionAnnotation;
    private Text commentText;
    private Text copyrightText;
    private Text authorText;
    private Text dateText;
    private Button savePreferencesButton;
    List<PapyrusDefinitionAnnotation> oldVersionAnnotations = new ArrayList<PapyrusDefinitionAnnotation>();
    Combo commentHistory;
    final List<String> availableComments = new ArrayList<String>();

    public ProfileDefinitionDialog(Shell parentShell, Profile profileToDefine) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.profileToDefine = profileToDefine;
        this.computeHistoryAnnotations();
    }

    private void computeHistoryAnnotations() {
        this.oldVersionAnnotations = Util.getAllPapyrusDefinitionAnnotation(this.profileToDefine);
    }

    protected void okPressed() {
        if (this.savePreferencesButton.getSelection()) {
            Activator.getDefault().getPreferenceStore().setValue("ProfileDefinitionPreferenceConstants.author.name", this.authorText.getText());
            Activator.getDefault().getPreferenceStore().setValue("ProfileDefinitionPreferenceConstants.copyright", this.copyrightText.getText());
        }
        this.papyrusDefinitionAnnotation = new PapyrusDefinitionAnnotation(this.newVersionValue, this.commentText.getText(), this.copyrightText.getText(), this.dateText.getText(), this.authorText.getText());
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        this.setTitle("Information about new definition");
        this.setTitleImage(ImageManager.getImage(PROFILE_DEFINITION));
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setFont(parentComposite.getFont());
        this.computeVersionValues();
        Composite versionArea = this.createVersionArea(composite);
        GridData gd = new GridData(4, 0x1000000, true, false);
        versionArea.setLayoutData((Object)gd);
        Composite infoArea = this.createInfoArea(composite);
        gd = new GridData(4, 4, true, true);
        infoArea.setLayoutData((Object)gd);
        Composite commentArea = this.createCommentArea(composite);
        gd = new GridData(4, 0x1000000, true, true, 2, 1);
        commentArea.setLayoutData((Object)gd);
        Composite copyrightArea = this.createCopyrightArea(composite);
        gd = new GridData(4, 0x1000000, true, true, 2, 1);
        copyrightArea.setLayoutData((Object)gd);
        Composite advancedArea = this.createAdvancedArea(composite);
        gd = new GridData(4, 0x1000000, true, true, 2, 1);
        advancedArea.setLayoutData((Object)gd);
        ProfileDefinitionDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    private Composite createAdvancedArea(Composite composite) {
        Composite parent = new Composite(composite, 0x1000000);
        GridLayout layout = new GridLayout();
        parent.setLayout((Layout)layout);
        this.savePreferencesButton = new Button(parent, 32);
        this.savePreferencesButton.setText("Store author and copyright values in preferences.");
        GridData gd = new GridData(1, 0x1000000, false, true);
        this.savePreferencesButton.setLayoutData((Object)gd);
        return parent;
    }

    private Composite createCopyrightArea(Composite composite) {
        Group group = new Group(composite, 0x1000000);
        group.setText("Copyright");
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        this.copyrightText = new Text((Composite)group, 2626);
        this.copyrightText.setText(Activator.getDefault().getPreferenceStore().getString("ProfileDefinitionPreferenceConstants.copyright"));
        GridData gd = new GridData(4, 0x1000000, true, true);
        gd.heightHint = 60;
        this.copyrightText.setLayoutData((Object)gd);
        return group;
    }

    private Composite createInfoArea(Composite composite) {
        Group group = new Group(composite, 0x1000000);
        group.setText("Info");
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        Label dateLabel = new Label((Composite)group, 16384);
        dateLabel.setText("Date");
        GridData gd = new GridData(4, 0x1000000, true, false);
        dateLabel.setLayoutData((Object)gd);
        this.dateText = new Text((Composite)group, 2052);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        TimeZone local = TimeZone.getDefault();
        sdf.setTimeZone(local);
        String dateString = sdf.format(new Date());
        this.dateText.setText(dateString);
        gd = new GridData(4, 0x1000000, true, false);
        this.dateText.setLayoutData((Object)gd);
        Label authorLabel = new Label((Composite)group, 16384);
        authorLabel.setText("Author");
        gd = new GridData(4, 0x1000000, true, false);
        authorLabel.setLayoutData((Object)gd);
        this.authorText = new Text((Composite)group, 2052);
        this.authorText.setText(Activator.getDefault().getPreferenceStore().getString("ProfileDefinitionPreferenceConstants.author.name"));
        gd = new GridData(4, 0x1000000, true, false);
        this.authorText.setLayoutData((Object)gd);
        return group;
    }

    private Composite createCommentArea(Composite composite) {
        Group group = new Group(composite, 0x1000000);
        group.setText("Comments");
        GridLayout layout = new GridLayout(1, false);
        group.setLayout((Layout)layout);
        this.commentText = new Text((Composite)group, 2626);
        this.commentText.setText("");
        GridData gd = new GridData(4, 0x1000000, true, true);
        gd.heightHint = 60;
        this.commentText.setLayoutData((Object)gd);
        this.commentHistory = new Combo((Composite)group, 12);
        ListIterator<PapyrusDefinitionAnnotation> it = this.oldVersionAnnotations.listIterator();
        while (it.hasNext()) {
            String comment = ((PapyrusDefinitionAnnotation)it.next()).getComment();
            if (comment == null || "".equals(comment)) continue;
            this.availableComments.add(comment);
        }
        for (String comment : this.availableComments) {
            this.commentHistory.add(comment.substring(0, Math.min(comment.length(), 80)));
        }
        this.commentHistory.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index = ProfileDefinitionDialog.this.commentHistory.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                String text = ProfileDefinitionDialog.this.availableComments.get(index);
                ProfileDefinitionDialog.this.commentText.setText(text);
            }
        });
        gd = new GridData(4, 0x1000000, true, true);
        this.commentHistory.setLayoutData((Object)gd);
        return group;
    }

    private Composite createVersionArea(Composite composite) {
        Group group = new Group(composite, 0x1000000);
        group.setText("Version");
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        Label oldVersionLabel = new Label((Composite)group, 16384);
        oldVersionLabel.setText("Previous Version");
        GridData gd = new GridData(4, 0x1000000, true, false);
        oldVersionLabel.setLayoutData((Object)gd);
        Text oldVersionText = new Text((Composite)group, 2060);
        oldVersionText.setText(this.oldVersionValue.toString());
        gd = new GridData(4, 0x1000000, true, false);
        oldVersionText.setLayoutData((Object)gd);
        this.devVersionButton = new Button((Composite)group, 32);
        this.devVersionButton.setText("Development Version");
        gd = new GridData(4, 0x1000000, true, false);
        this.devVersionButton.setLayoutData((Object)gd);
        this.devVersionButton.setSelection(true);
        this.devVersionButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProfileDefinitionDialog.this.developmentVersionButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Text devVersionText = new Text((Composite)group, 2060);
        devVersionText.setText(this.devVersionValue.toString());
        gd = new GridData(4, 0x1000000, true, false);
        devVersionText.setLayoutData((Object)gd);
        this.releaseVersionButton = new Button((Composite)group, 32);
        this.releaseVersionButton.setText("Release Version");
        gd = new GridData(4, 0x1000000, true, false);
        this.releaseVersionButton.setLayoutData((Object)gd);
        this.releaseVersionButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProfileDefinitionDialog.this.releaseVersionButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Text releaseVersionText = new Text((Composite)group, 2060);
        releaseVersionText.setText(this.releaseVersionValue.toString());
        gd = new GridData(4, 0x1000000, true, false);
        releaseVersionText.setLayoutData((Object)gd);
        this.majorReleaseVersionButton = new Button((Composite)group, 32);
        this.majorReleaseVersionButton.setText("Major Release");
        gd = new GridData(4, 0x1000000, true, false);
        this.majorReleaseVersionButton.setLayoutData((Object)gd);
        this.majorReleaseVersionButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProfileDefinitionDialog.this.majorReleaseVersionButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Text majorReleaseVersionText = new Text((Composite)group, 2060);
        majorReleaseVersionText.setText(this.majorReleaseVersionValue.toString());
        gd = new GridData(4, 0x1000000, true, false);
        majorReleaseVersionText.setLayoutData((Object)gd);
        this.customVersionButton = new Button((Composite)group, 32);
        this.customVersionButton.setText("Custom");
        gd = new GridData(4, 0x1000000, true, false);
        this.customVersionButton.setLayoutData((Object)gd);
        this.customVersionButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProfileDefinitionDialog.this.customVersionButtonPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.customVersionText = new Text((Composite)group, 2052);
        this.customVersionText.setEditable(false);
        this.customVersionText.setText(this.customReleaseVersionValue.toString());
        gd = new GridData(4, 0x1000000, true, false);
        this.customVersionText.setLayoutData((Object)gd);
        this.customVersionText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ProfileDefinitionDialog.this.customVersionText.setText(ProfileDefinitionDialog.this.customReleaseVersionValue.toString());
            }

            public void focusLost(FocusEvent e) {
                try {
                    ProfileDefinitionDialog.this.customReleaseVersionValue = Version.parseVersion(ProfileDefinitionDialog.this.customVersionText.getText());
                    ProfileDefinitionDialog.this.newVersionValue = ProfileDefinitionDialog.this.customReleaseVersionValue;
                    ProfileDefinitionDialog.this.setErrorMessage(null);
                }
                catch (IllegalArgumentException iae) {
                    ProfileDefinitionDialog.this.setErrorMessage("Custom version number format should be X.Y.Z, not " + ProfileDefinitionDialog.this.customVersionText.getText());
                    ProfileDefinitionDialog.this.customReleaseVersionValue = ProfileDefinitionDialog.this.devVersionValue;
                    ProfileDefinitionDialog.this.developmentVersionButtonPressed();
                }
            }
        });
        return group;
    }

    private void computeVersionValues() {
        this.oldVersionValue = Util.getProfileDefinitionVersion(this.profileToDefine);
        this.devVersionValue = new Version(this.oldVersionValue.getMajor(), this.oldVersionValue.getMinor(), this.oldVersionValue.getMicro() + 1);
        this.releaseVersionValue = new Version(this.oldVersionValue.getMajor(), this.oldVersionValue.getMinor() + 1, 0);
        this.majorReleaseVersionValue = new Version(this.oldVersionValue.getMajor() + 1, 0, 0);
        this.customReleaseVersionValue = this.devVersionValue;
        this.newVersionValue = this.devVersionValue;
    }

    private void developmentVersionButtonPressed() {
        this.devVersionButton.setSelection(true);
        this.releaseVersionButton.setSelection(false);
        this.majorReleaseVersionButton.setSelection(false);
        this.customVersionButton.setSelection(false);
        this.newVersionValue = this.devVersionValue;
        this.customVersionText.setEditable(false);
    }

    private void releaseVersionButtonPressed() {
        this.devVersionButton.setSelection(false);
        this.releaseVersionButton.setSelection(true);
        this.majorReleaseVersionButton.setSelection(false);
        this.customVersionButton.setSelection(false);
        this.newVersionValue = this.releaseVersionValue;
        this.customVersionText.setEditable(false);
    }

    private void majorReleaseVersionButtonPressed() {
        this.devVersionButton.setSelection(false);
        this.releaseVersionButton.setSelection(false);
        this.majorReleaseVersionButton.setSelection(true);
        this.customVersionButton.setSelection(false);
        this.newVersionValue = this.majorReleaseVersionValue;
        this.customVersionText.setEditable(false);
    }

    private void customVersionButtonPressed() {
        this.devVersionButton.setSelection(false);
        this.releaseVersionButton.setSelection(false);
        this.majorReleaseVersionButton.setSelection(false);
        this.customVersionButton.setSelection(true);
        this.newVersionValue = this.customReleaseVersionValue;
        this.customVersionText.setEditable(true);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        shell.setText("Profile Definition");
    }

    public PapyrusDefinitionAnnotation getPapyrusDefinitionAnnotation() {
        return this.papyrusDefinitionAnnotation;
    }
}

