/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.modelexplorer.handler.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.profile.Activator;
import org.eclipse.papyrus.profile.ui.dialogs.ElementImportTreeSelectionDialog;
import org.eclipse.papyrus.ui.toolbox.notification.Type;
import org.eclipse.papyrus.ui.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileTreeSelectionDialog
extends ElementImportTreeSelectionDialog {
    List<String> subProfilesList;

    public ProfileTreeSelectionDialog(Shell parent, Package model) {
        super(parent, model);
        this.subSelection = true;
        this.subProfilesList = new ArrayList<String>();
    }

    public ProfileTreeSelectionDialog(Shell parent, List<Package> model) {
        this(parent, model, new ArrayList<String>());
        this.subSelection = true;
    }

    public ProfileTreeSelectionDialog(Shell parent, List<Package> model, List<String> subprofiles) {
        super(parent, model);
        this.subSelection = true;
        this.subProfilesList = subprofiles;
    }

    @Override
    public ArrayList getResult() {
        ArrayList<Profile> profileList = new ArrayList<Profile>();
        for (Element currentElement : this.elementsToImport) {
            if (!(currentElement instanceof Profile)) continue;
            Profile profile = (Profile)currentElement;
            profileList.add(profile);
        }
        return profileList;
    }

    public ArrayList<Profile> getValidResult() {
        final ArrayList invalidProfiles = new ArrayList();
        final ArrayList<Profile> validProfiles = new ArrayList<Profile>();
        if (!this.elementsToImport.isEmpty()) {
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)((EObject)this.elementsToImport.get(0)));
            AbstractTransactionalCommand validationCommand = new AbstractTransactionalCommand((TransactionalEditingDomain)editingDomain, "Profile validation", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    for (Element element : ProfileTreeSelectionDialog.this.elementsToImport) {
                        if (!(element instanceof Profile)) continue;
                        Diagnostician diagnostician = new Diagnostician();
                        Profile profile = (Profile)element;
                        EPackage ePackage = profile.getDefinition();
                        Diagnostic diagnostic = diagnostician.validate((EObject)ePackage);
                        if (diagnostic.getSeverity() != 4) {
                            validProfiles.add(profile);
                            continue;
                        }
                        invalidProfiles.add(profile);
                        Activator.logError(diagnostic.toString());
                    }
                    return CommandResult.newOKCommandResult();
                }
            };
            editingDomain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)validationCommand));
            if (!invalidProfiles.isEmpty()) {
                StringBuilder message = new StringBuilder("<form><p>The following profiles are invalid : </p>");
                Iterator iterator = invalidProfiles.iterator();
                while (iterator.hasNext()) {
                    message.append("<p> - ");
                    Profile profile = (Profile)iterator.next();
                    String profileLabel = profile.getLabel();
                    message.append(profileLabel);
                    message.append("</p>");
                }
                message.append("<p>These profiles were removed from the list of selected profiles, and should be corrected and validated before they are applied. </p></form>");
                String text = message.toString();
                new NotificationBuilder().setAsynchronous(false).setTemporary(false).setHTML(true).setMessage(text).setType(Type.WARNING).run();
            }
        }
        return validProfiles;
    }

    @Override
    protected void buildImportTreeList(TreeItem elemTree, Package _package) {
        for (Element elem : _package.getPackagedElements()) {
            TreeItem item;
            if (elem instanceof Profile) {
                item = new TreeItem(elemTree, 0);
                item.setText(((Package)elem).getName());
                item.setData((Object)elem);
                item.setImage(IMG_PROFILE);
                String name = ((Profile)elem).getQualifiedName();
                if (name != null && this.subProfilesList.contains(name)) {
                    item.setChecked(true);
                    this.elementsToImport.add(elem);
                }
                this.buildImportTreeList(item, (Package)elem);
                continue;
            }
            if (!(elem instanceof Package)) continue;
            item = new TreeItem(elemTree, 0);
            item.setText(((Package)elem).getName());
            item.setData((Object)elem);
            item.setImage(IMG_PACKAGE);
            this.buildImportTreeList(item, (Package)elem);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Choose profile(s) to apply");
    }
}

