/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.extensionpoints.uml2.profile.RegisteredProfile;
import org.eclipse.papyrus.extensionpoints.uml2.standard.FilteredRegisteredElementsSelectionDialog;
import org.eclipse.papyrus.extensionpoints.uml2.utils.Util;
import org.eclipse.papyrus.profile.ui.dialogs.Message;
import org.eclipse.papyrus.profile.ui.dialogs.ProfileTreeSelectionDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisteredProfileSelectionDialog
extends FilteredRegisteredElementsSelectionDialog {
    private RegisteredProfile[] regProfiles;
    private Package currentPackage;

    public RegisteredProfileSelectionDialog(Composite parent, Package umlPackage) {
        super(parent.getShell(), true, (Object[])RegisteredProfile.getRegisteredProfiles(), new ArrayList(), "Apply profiles from Papyrus repository :", "");
        this.currentPackage = umlPackage;
    }

    public List<Profile> run() {
        this.open();
        return this.treatSelection();
    }

    private List<Profile> treatSelection() {
        Object[] selection = this.getResult();
        boolean hasChanged = false;
        ResourceSet resourceSet = Util.getResourceSet((EObject)this.currentPackage);
        if (selection == null) {
            return new ArrayList<Profile>();
        }
        ArrayList<Package> listOfProfileToApply = new ArrayList<Package>();
        ArrayList<String> subprofilesList = new ArrayList<String>();
        int i = 0;
        while (i < selection.length) {
            RegisteredProfile currentProfile = (RegisteredProfile)selection[i];
            URI modelUri = currentProfile.uri;
            Resource modelResource = resourceSet.getResource(modelUri, true);
            String qualifiedNames = currentProfile.qualifiednames;
            String[] profiles = qualifiedNames.split(",");
            int j = 0;
            while (j < profiles.length) {
                String string = profiles[j].trim();
                subprofilesList.add(string);
                ++j;
            }
            if (modelResource.getContents().get(0) instanceof Profile) {
                Message processMsg = new Message("Profile application", "Loading profiles...");
                processMsg.open();
                Profile profileToApply = (Profile)modelResource.getContents().get(0);
                processMsg.close();
                listOfProfileToApply.add((Package)profileToApply);
            }
            ++i;
        }
        if (!listOfProfileToApply.isEmpty()) {
            ProfileTreeSelectionDialog profileDialog = new ProfileTreeSelectionDialog(this.getShell(), listOfProfileToApply, subprofilesList);
            int returnValue = profileDialog.open();
            if (returnValue == 0) {
                return profileDialog.getResult();
            }
            new ArrayList();
        }
        return new ArrayList<Profile>();
    }
}

