/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.ui.items;

import java.util.List;
import org.eclipse.papyrus.profile.Message;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;

public class MetaclassItems {
    public MetaclassItems(Table table, Property property, Object value) {
        if (property.getLower() > 0) {
            Message.warning("Property of type Metaclass and multiplicity lower value != 0.\nThe profile is ill formed !");
        }
        if (property.isMultivalued()) {
            List propValues = (List)value;
            int i = 0;
            while (i < propValues.size()) {
                this.createItem(table, property, propValues.get(i));
                ++i;
            }
        } else if (value != null) {
            this.createItem(table, property, value);
        }
    }

    private void createItem(Table table, Property property, Object object) {
        if (object != null) {
            NamedElement baseNamedElement;
            TableItem propValueItem = new TableItem(table, 0);
            String label = object.toString();
            if (object instanceof NamedElement && (baseNamedElement = (NamedElement)object).isSetName()) {
                label = baseNamedElement.getQualifiedName();
            }
            propValueItem.setText(label);
            propValueItem.setData(object);
        }
    }
}

