/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.profile.wizard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.extensionpoints.uml2.profile.RegisteredProfile;
import org.eclipse.papyrus.extensionpoints.uml2.utils.Util;
import org.eclipse.papyrus.profile.Activator;
import org.eclipse.papyrus.umlutils.PackageUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.editor.presentation.UMLModelWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLModelWithProfileWizard
extends UMLModelWizard {
    protected IWizardPage profilePage;
    protected Collection<RegisteredProfile> rProfilesToApply = new HashSet<RegisteredProfile>();

    public UMLModelWithProfileWizard() {
        this.initProfileList();
    }

    protected void initProfileList() {
    }

    public void addPages() {
        super.addPages();
        this.profilePage = new UMLModelWizardProfilesPage();
        this.addPage(this.profilePage);
    }

    protected EObject createInitialModel() {
        EClass eClass = (EClass)this.umlPackage.getEClassifier(this.initialObjectCreationPage.getInitialObjectName());
        EObject rootObject = this.umlFactory.create(eClass);
        this.applySelectedProfiles(rootObject, this.rProfilesToApply);
        return rootObject;
    }

    protected int applySelectedProfiles(EObject root, Collection<RegisteredProfile> rProfilesToApply) {
        int num = 0;
        Iterator<RegisteredProfile> it = rProfilesToApply.iterator();
        while (it.hasNext()) {
            num += this.applySelectedProfile(root, it.next());
        }
        return num;
    }

    protected int applySelectedProfile(EObject root, RegisteredProfile rProfile) {
        int num = 0;
        if (root instanceof Package) {
            URI modelUri = rProfile.uri;
            Resource modelResource = Util.getResourceSet((EObject)root).getResource(modelUri, true);
            if (modelResource.getContents().get(0) instanceof Profile) {
                if ("".equals(rProfile.qualifiednames)) {
                    PackageUtil.applyProfile((Package)((Package)root), (Profile)((Profile)modelResource.getContents().get(0)), (boolean)true);
                    ++num;
                } else {
                    String[] profiles = rProfile.qualifiednames.split(",");
                    ArrayList<String> subprofilesList = new ArrayList<String>();
                    int j = 0;
                    while (j < profiles.length) {
                        String string = profiles[j].trim();
                        subprofilesList.add(string);
                        ++j;
                    }
                    return this.applySelectedProfile((Package)root, (Profile)modelResource.getContents().get(0), subprofilesList);
                }
            }
        }
        return num;
    }

    protected int applySelectedProfile(Package root, Profile profile, List<String> subprofilesList) {
        int num = 0;
        TreeIterator it = profile.eAllContents();
        while (it.hasNext()) {
            String name;
            EObject o = (EObject)it.next();
            if (!(o instanceof Profile) || !subprofilesList.contains(name = ((Profile)o).getQualifiedName())) continue;
            PackageUtil.applyProfile((Package)root, (Profile)((Profile)o), (boolean)true);
            ++num;
        }
        return num;
    }

    protected void addProfile(String name, String path) {
        this.addProfile(name, path, "");
    }

    protected void addProfile(String name, String path, String qualifiedNames) {
        RegisteredProfile profile = RegisteredProfile.getRegisteredProfile((String)name, (String)path);
        if (profile != null) {
            this.rProfilesToApply.add(profile);
        } else {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.papyrus.profile", 4, "impossible to find profile: " + name + " in: " + path, null));
        }
    }

    public class UMLModelWizardProfilesPage
    extends WizardPage {
        protected Table table;
        protected TableViewer tableViewer;
        protected static final int NUMBER_COLUMNS = 1;

        public UMLModelWizardProfilesPage() {
            super("com.cea.papyrus.profilespage");
            this.setTitle("Profile application");
            this.setMessage("Choose the set of profiles that will be applied to the new model");
        }

        protected boolean validatePage() {
            return true;
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.verticalSpacing = 12;
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
            data.horizontalAlignment = 4;
            composite.setLayoutData((Object)data);
            this.createTable(composite);
            this.fillTable();
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }

        private void createTable(Composite parent) {
            this.table = new Table(parent, 101154);
            GridData gridData = new GridData(1808);
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalSpan = 3;
            this.table.setLayoutData((Object)gridData);
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.table.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (32 == e.detail) {
                        TableItem item = (TableItem)e.item;
                        RegisteredProfile rProfile = null;
                        if (item != null) {
                            rProfile = (RegisteredProfile)item.getData();
                        }
                        if (rProfile != null) {
                            if (item.getChecked()) {
                                ((UMLModelWizardProfilesPage)UMLModelWizardProfilesPage.this).UMLModelWithProfileWizard.this.rProfilesToApply.add(rProfile);
                            } else {
                                ((UMLModelWizardProfilesPage)UMLModelWizardProfilesPage.this).UMLModelWithProfileWizard.this.rProfilesToApply.remove(rProfile);
                            }
                        }
                    }
                }
            });
            TableColumn column = new TableColumn(this.table, 16384, 0);
            column.setText("Profile");
            column.setWidth(400);
        }

        private void fillTable() {
            RegisteredProfile[] rProfiles = RegisteredProfile.getRegisteredProfiles();
            int i = 0;
            while (i < rProfiles.length) {
                TableItem item = new TableItem(this.table, 32);
                RegisteredProfile rProfile = rProfiles[i];
                item.setData((Object)rProfile);
                item.setText(rProfile.name);
                item.setChecked(UMLModelWithProfileWizard.this.rProfilesToApply.contains(rProfile));
                ++i;
            }
        }
    }
}

