/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.blockdefinition.preferences;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.preferences.utils.PreferenceConstantHelper;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.preferences.BlockDefinitionDiagramLinkPreferencePage;
import org.eclipse.papyrus.sysml.diagram.common.preferences.LabelPreferenceHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class CustomAssociationPreferencePage
extends BlockDefinitionDiagramLinkPreferencePage {
    public static String prefKey = "BlockDefinition_link_sysml_association";
    public static final Map<String, Boolean> labelDefaultVisibilityMap = new LinkedHashMap<String, Boolean>();
    protected Button bttnSourceRoleVisibility;
    protected Button bttnSourceRoleDerive;
    protected Button bttnSourceRoleName;
    protected Button bttnSourceRoleType;
    protected Button bttnSourceMultMultiplicity;
    protected Button bttnSourceMultDefault_Multiplicity;
    protected Button bttnSourceMultModifiers;
    protected Button bttnTargetRoleVisibility;
    protected Button bttnTargetRoleDerive;
    protected Button bttnTargetRoleName;
    protected Button bttnTargetRoleType;
    protected Button bttnTargetMultMultiplicity;
    protected Button bttnTargetMultDefault_Multiplicity;
    protected Button bttnTargetMultModifiers;
    public static String sourceRoleLabelKey;
    public static String sourceMultLabelKey;
    public static String targetRoleLabelKey;
    public static String targetMultLabelKey;
    private String sourceRoleLabelDisplayPreferenceKey = LabelPreferenceHelper.getPreferenceConstant((String)sourceRoleLabelKey, (String)"label.display");
    private String sourceMultLabelDisplayPreferenceKey = LabelPreferenceHelper.getPreferenceConstant((String)sourceMultLabelKey, (String)"label.display");
    private String targetRoleLabelDisplayPreferenceKey = LabelPreferenceHelper.getPreferenceConstant((String)targetRoleLabelKey, (String)"label.display");
    private String targetMultLabelDisplayPreferenceKey = LabelPreferenceHelper.getPreferenceConstant((String)targetMultLabelKey, (String)"label.display");
    private int sourceRoleDisplayValue = this.getPreferenceStore().getInt(this.sourceRoleLabelDisplayPreferenceKey);
    private int sourceMultDisplayValue = this.getPreferenceStore().getInt(this.sourceMultLabelDisplayPreferenceKey);
    private int targetRoleDisplayValue = this.getPreferenceStore().getInt(this.targetRoleLabelDisplayPreferenceKey);
    private int targetMultDisplayValue = this.getPreferenceStore().getInt(this.targetMultLabelDisplayPreferenceKey);

    static {
        labelDefaultVisibilityMap.put("Stereotype", Boolean.TRUE);
        labelDefaultVisibilityMap.put("Name", Boolean.TRUE);
        labelDefaultVisibilityMap.put("SourceRole", Boolean.TRUE);
        labelDefaultVisibilityMap.put("SourceMultiplicity", Boolean.TRUE);
        labelDefaultVisibilityMap.put("TargetRole", Boolean.TRUE);
        labelDefaultVisibilityMap.put("TargetMultiplicity", Boolean.TRUE);
        Collections.unmodifiableMap(labelDefaultVisibilityMap);
        sourceRoleLabelKey = "BlockDefinition_link_sysml_association-linklabel_uml_association_source_role";
        sourceMultLabelKey = "BlockDefinition_link_sysml_association-linklabel_uml_association_source_multiplicity";
        targetRoleLabelKey = "BlockDefinition_link_sysml_association-linklabel_uml_association_target_role";
        targetMultLabelKey = "BlockDefinition_link_sysml_association-linklabel_uml_association_target_multiplicity";
    }

    public CustomAssociationPreferencePage() {
        this.setPreferenceKey("BlockDefinition_link_sysml_association");
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(LabelPreferenceHelper.getPreferenceConstant((String)sourceRoleLabelKey, (String)"label.display"), 8);
        store.setDefault(LabelPreferenceHelper.getPreferenceConstant((String)sourceMultLabelKey, (String)"label.display"), 32);
        store.setDefault(LabelPreferenceHelper.getPreferenceConstant((String)targetRoleLabelKey, (String)"label.display"), 8);
        store.setDefault(LabelPreferenceHelper.getPreferenceConstant((String)targetMultLabelKey, (String)"label.display"), 32);
        for (String labelName : labelDefaultVisibilityMap.keySet()) {
            String showLabelKey = PreferenceConstantHelper.getCompartmentElementConstant((String)prefKey, (String)labelName, (int)20);
            store.setDefault(showLabelKey, labelDefaultVisibilityMap.get(labelName).booleanValue());
        }
    }

    protected void initializeLabelsList() {
        for (String name : labelDefaultVisibilityMap.keySet()) {
            this.labelsList.add(name);
        }
    }

    protected void createSourceRoleLabelPreferencesButtons(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText("Source Role Label Display");
        group.setLayout((Layout)new FormLayout());
        this.bttnSourceRoleVisibility = this.createSourceRoleCheckButton((Composite)group, "Visibility", 2);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.bttnSourceRoleVisibility.setLayoutData((Object)data);
        this.bttnSourceRoleDerive = this.createSourceRoleCheckButton((Composite)group, "Derive", 4);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnSourceRoleVisibility, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnSourceRoleDerive.setLayoutData((Object)data);
        this.bttnSourceRoleName = this.createSourceRoleCheckButton((Composite)group, "Name", 8);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnSourceRoleDerive, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnSourceRoleName.setLayoutData((Object)data);
        this.bttnSourceRoleType = this.createSourceRoleCheckButton((Composite)group, "Type", 16);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnSourceRoleName, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnSourceRoleType.setLayoutData((Object)data);
    }

    protected void createSourceMultLabelPreferencesButtons(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText("Source Multiplicity Label Display");
        group.setLayout((Layout)new FormLayout());
        this.bttnSourceMultMultiplicity = this.createSourceMultCheckButton((Composite)group, "Multiplicity", 32);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.bttnSourceMultMultiplicity.setLayoutData((Object)data);
        this.bttnSourceMultDefault_Multiplicity = this.createSourceMultCheckButton((Composite)group, "Default_Multiplicity", 0x100000);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnSourceMultMultiplicity, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnSourceMultDefault_Multiplicity.setLayoutData((Object)data);
        this.bttnSourceMultModifiers = this.createSourceMultCheckButton((Composite)group, "Modifiers", 128);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnSourceMultDefault_Multiplicity, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnSourceMultModifiers.setLayoutData((Object)data);
    }

    protected void createTargetRoleLabelPreferencesButtons(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText("Target Role Label Display");
        group.setLayout((Layout)new FormLayout());
        this.bttnTargetRoleVisibility = this.createTargetRoleCheckButton((Composite)group, "Visibility", 2);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.bttnTargetRoleVisibility.setLayoutData((Object)data);
        this.bttnTargetRoleDerive = this.createTargetRoleCheckButton((Composite)group, "Derive", 4);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnTargetRoleVisibility, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnTargetRoleDerive.setLayoutData((Object)data);
        this.bttnTargetRoleName = this.createTargetRoleCheckButton((Composite)group, "Name", 8);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnTargetRoleDerive, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnTargetRoleName.setLayoutData((Object)data);
        this.bttnTargetRoleType = this.createTargetRoleCheckButton((Composite)group, "Type", 16);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnTargetRoleName, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnTargetRoleType.setLayoutData((Object)data);
    }

    protected void createTargetMultLabelPreferencesButtons(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText("Target Multiplicity Label Display");
        group.setLayout((Layout)new FormLayout());
        this.bttnTargetMultMultiplicity = this.createTargetMultCheckButton((Composite)group, "Multiplicity", 32);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.bttnTargetMultMultiplicity.setLayoutData((Object)data);
        this.bttnTargetMultDefault_Multiplicity = this.createTargetMultCheckButton((Composite)group, "Default_Multiplicity", 0x100000);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnTargetMultMultiplicity, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnTargetMultDefault_Multiplicity.setLayoutData((Object)data);
        this.bttnTargetMultModifiers = this.createTargetMultCheckButton((Composite)group, "Modifiers", 128);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnTargetMultDefault_Multiplicity, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnTargetMultModifiers.setLayoutData((Object)data);
    }

    protected void createPageContents(Composite parent) {
        super.createPageContents(parent);
        this.createSourceRoleLabelPreferencesButtons(parent);
        this.createSourceMultLabelPreferencesButtons(parent);
        this.createTargetRoleLabelPreferencesButtons(parent);
        this.createTargetMultLabelPreferencesButtons(parent);
        this.refreshButtons();
    }

    protected void loadDefaultPreferences() {
        this.sourceRoleDisplayValue = this.getPreferenceStore().getDefaultInt(this.sourceRoleLabelDisplayPreferenceKey);
        this.sourceMultDisplayValue = this.getPreferenceStore().getDefaultInt(this.sourceMultLabelDisplayPreferenceKey);
        this.targetRoleDisplayValue = this.getPreferenceStore().getDefaultInt(this.targetRoleLabelDisplayPreferenceKey);
        this.targetMultDisplayValue = this.getPreferenceStore().getDefaultInt(this.targetMultLabelDisplayPreferenceKey);
        this.refreshButtons();
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void refreshButtons() {
        this.bttnSourceRoleVisibility.setSelection((this.sourceRoleDisplayValue & 2) == 2);
        this.bttnSourceRoleDerive.setSelection((this.sourceRoleDisplayValue & 4) == 4);
        this.bttnSourceRoleName.setSelection((this.sourceRoleDisplayValue & 8) == 8);
        this.bttnSourceRoleType.setSelection((this.sourceRoleDisplayValue & 0x10) == 16);
        this.bttnSourceMultMultiplicity.setSelection((this.sourceMultDisplayValue & 0x20) == 32);
        this.bttnSourceMultDefault_Multiplicity.setSelection((this.sourceMultDisplayValue & 0x100000) == 0x100000);
        this.bttnSourceMultModifiers.setSelection((this.sourceMultDisplayValue & 0x80) == 128);
        this.bttnTargetRoleVisibility.setSelection((this.targetRoleDisplayValue & 2) == 2);
        this.bttnTargetRoleDerive.setSelection((this.targetRoleDisplayValue & 4) == 4);
        this.bttnTargetRoleName.setSelection((this.targetRoleDisplayValue & 8) == 8);
        this.bttnTargetRoleType.setSelection((this.targetRoleDisplayValue & 0x10) == 16);
        this.bttnTargetMultMultiplicity.setSelection((this.targetMultDisplayValue & 0x20) == 32);
        this.bttnTargetMultDefault_Multiplicity.setSelection((this.targetMultDisplayValue & 0x100000) == 0x100000);
        this.bttnTargetMultModifiers.setSelection((this.targetMultDisplayValue & 0x80) == 128);
    }

    protected void storePreferences() {
        super.storePreferences();
        IPreferenceStore store = this.getPreferenceStore();
        if (this.sourceRoleDisplayValue != store.getInt(this.sourceRoleLabelDisplayPreferenceKey)) {
            store.setValue(this.sourceRoleLabelDisplayPreferenceKey, this.sourceRoleDisplayValue);
        }
        if (this.sourceMultDisplayValue != store.getInt(this.sourceMultLabelDisplayPreferenceKey)) {
            store.setValue(this.sourceMultLabelDisplayPreferenceKey, this.sourceMultDisplayValue);
        }
        if (this.targetRoleDisplayValue != store.getInt(this.targetRoleLabelDisplayPreferenceKey)) {
            store.setValue(this.targetRoleLabelDisplayPreferenceKey, this.targetRoleDisplayValue);
        }
        if (this.targetMultDisplayValue != store.getInt(this.targetMultLabelDisplayPreferenceKey)) {
            store.setValue(this.targetMultLabelDisplayPreferenceKey, this.targetMultDisplayValue);
        }
    }

    protected Button createSourceRoleCheckButton(Composite parent, String label, int mask) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SourceRoleAppearenceSelectionListener(mask));
        return button;
    }

    protected Button createSourceMultCheckButton(Composite parent, String label, int mask) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new SourceMultAppearenceSelectionListener(mask));
        return button;
    }

    protected Button createTargetRoleCheckButton(Composite parent, String label, int mask) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new TargetRoleAppearenceSelectionListener(mask));
        return button;
    }

    protected Button createTargetMultCheckButton(Composite parent, String label, int mask) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new TargetMultAppearenceSelectionListener(mask));
        return button;
    }

    private class SourceMultAppearenceSelectionListener
    implements SelectionListener {
        private final int style;

        public SourceMultAppearenceSelectionListener(int style) {
            this.style = style;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CustomAssociationPreferencePage customAssociationPreferencePage = CustomAssociationPreferencePage.this;
            customAssociationPreferencePage.sourceMultDisplayValue = customAssociationPreferencePage.sourceMultDisplayValue ^ this.style;
            CustomAssociationPreferencePage.this.refreshButtons();
        }
    }

    private class SourceRoleAppearenceSelectionListener
    implements SelectionListener {
        private final int style;

        public SourceRoleAppearenceSelectionListener(int style) {
            this.style = style;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CustomAssociationPreferencePage customAssociationPreferencePage = CustomAssociationPreferencePage.this;
            customAssociationPreferencePage.sourceRoleDisplayValue = customAssociationPreferencePage.sourceRoleDisplayValue ^ this.style;
            CustomAssociationPreferencePage.this.refreshButtons();
        }
    }

    private class TargetMultAppearenceSelectionListener
    implements SelectionListener {
        private final int style;

        public TargetMultAppearenceSelectionListener(int style) {
            this.style = style;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CustomAssociationPreferencePage customAssociationPreferencePage = CustomAssociationPreferencePage.this;
            customAssociationPreferencePage.targetMultDisplayValue = customAssociationPreferencePage.targetMultDisplayValue ^ this.style;
            CustomAssociationPreferencePage.this.refreshButtons();
        }
    }

    private class TargetRoleAppearenceSelectionListener
    implements SelectionListener {
        private final int style;

        public TargetRoleAppearenceSelectionListener(int style) {
            this.style = style;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            CustomAssociationPreferencePage customAssociationPreferencePage = CustomAssociationPreferencePage.this;
            customAssociationPreferencePage.targetRoleDisplayValue = customAssociationPreferencePage.targetRoleDisplayValue ^ this.style;
            CustomAssociationPreferencePage.this.refreshButtons();
        }
    }
}

