function [L, U] = LUgauss(A)
% Function che implementa la fattorizzazione LU senza pivoting
% Input: A: matrice quadrata invertibile
% call: [L, U] = LUgauss(A)
% Outputs: L: matrice triangolare inferiore
%          U: matrice triangolare superiore
n = size(A,1); % dimensione di A
L = eye(n);  % inizializzare la matrice L
for k = 1:n-1
    for i = k+1:n
        % calcolo dei moltiplicatori per eliminazione di gauss
        L(i,k) = A(i,k)/A(k,k); 
        for j = k:n
            % riduzione per righe della matrice A
            A(i,j) =  A(i,j) - L(i,k)*A(k,j);
        end
    end
end
U = A;