clear all 
close all

% punto a)
% plot della funzione per individuare 
% dove si trova lo zero
x=linspace(0,1,1000);
f=@(x) exp(-x).*sin(4*x-pi/2)+x;
figure(1)
plot(x,f(x)); grid;


% dal grafico si evince che un intervallo 
% per la ricerca dello zero e' [0.25,0.35]

% punto b)

g=@(x) (asin(-exp(x).*x)-pi/2)/4;

g1=@(x) -0.25*1./sqrt(1+x.*exp(x)).*exp(x).*(1-x);
figure(2)
plot(x,g1(x)); title(' grafico derivata g ');


% punto c) 
x0=0.25;
[iter,err]=fixedpoint(g,x0,1.e-6,20);
figure(3)
semilogy(1:length(err), err)
% sono necessarie 9 iterazioni

% punto d)
fp=@(x) 1+exp(-x).*(4*cos(4*x-pi/2)-sin(4*x-pi/2));
[x,iter]=Newton(f,fp,x0,1.e-6,20)
% sono necessarie solo 3 iterazioni, confermando l'ordine di
% convergenza quadratico del metodo di Newton


