% Esercizio2
clear all
close all
clc

% punto (a)

% dichiarare la matrice A 
A = [9 2 2 0 0; 3 6 0 1 0; 0 0.02 5 1/3 0; 0 0 3 5 1; 3 0 0 1 7];
% calcolare il vettore di termini noti
b = A*(3.*ones(5,1));
% fissare vettore iniziale, tolleranza e numero massimo di iterazioni
tol = 1.e-6; kmax = 3000; x0 = [2 2 2 2 2]'; 
% calcolo della soluzione con metodo di Richardson
ll=eig(A);
lmin=min(ll); lmax=max(ll);
alfa=2/(lmin+lmax)

[solR,errR,iterR]=Richardson(A,x0,b,tol,kmax,alfa);
% Grafico dell'errore
figure(1)
semilogy(1:length(errR),errR); title('Errore relativo Richarson');
% calcolo della soluzione con metodo di Gauss Seidel

% punto (b)
clear err
D=diag(diag(A));
B = -(tril(A)-D); C = -(triu(A)-D);
P_gs = inv(D-B)*C;
q = inv(D-B)*b;
x0 = [-1 0 0 0 -1]';
x1 = P_gs*x0+q;
k = 1; err(k) = norm(x1-x0)/norm(x1);
% ciclo iterativo
while (err(k) > tol && k <= kmax)
    x0 = x1; x1 = P_gs*x0+q;
    k = k+1;
    err(k) = norm(x1-x0)/norm(x1);
end
if k > kmax
    disp('raggiunto il numero massimo di iterazioni')
else
    disp('il numero di iterazioni per Gauss-Seidel')
    k
    figure(2)
    semilogy(1:length(err),err); title('Errore relativo Gauss-Seidel');
end

% punto (c)

% entrambi i metodi convergono essendo A diagonalmente dominante in senso
% stretto. Il metodo di Gauss Seidel converge piu' rapidamente perche' 
% il raggio spettrale della matrice di iterazione e' piu' piccolo di quello
% della matrice di Richarson. Infatti:
disp('raggio spettrale di Gauss-Seidel')
max(abs(eig(P_gs)))
disp('raggio spettrale di Richarson')
P=eye(5)-alfa*inv(D)*A;
max(abs(eig(P)))