function [sol,err,iter]=Richardson(A,b,x0,tol,kmax,alfa)

Dinv=inv(diag(diag(A)));

k=1;
x1=x0+alfa*Dinv*(b-A*x0);
err(k)=norm(x1-x0)/norm(x0);

while (err(k)>tol &&  k<= kmax)
    x0=x1; x1=x0+alfa*Dinv*(b-A*x0);
    k=k+1;
    err(k)=norm(x1-x0)/norm(x0);
    
end
if k> kmax
    error('non converge nel numero max d'' iterazioni');
end
sol=x1;
iter=k-1;
