function [x,iter] = NewtonMod(f,fp,x0,tol,maxiter,m)
% Function che implementa il metodo di Newton
% Inputs: f: funzione della quale si vuole approssimare una radice
%         fp: derivata di f
%         x0: condizione iniziale per le iterazioni
%         tol: tolleranza per fermare le iterazioni
%         maxiter: numero massimo di iterazioni
%         m: molteplicita' della radice
% Call: [x,iter] = Newton(f,fp,x0,tol,maxiter,m)
% Output: x: valore approssimato della radice
%         iter: numero di iterazioni necessarie per la convergenza
res = 1; iter = 0; % Inizializzare
while res && iter<maxiter
    x = x0-m*f(x0)/fp(x0); % modificare le iterazioni di Newton
    res = abs(x-x0) > tol*abs(x0); 
    iter = iter+1; 
    x0 = x;
end
if iter >= maxiter
    disp('Warning: the Newton''s algorithm did not converge!');
end