function [ITrapComp] = TrapezioComposta(N,a,b,f)
% Function che implementa la formula del trapezio composta
% Inputs: N: numero di sottointervalli     
%         a,b: estremi di integrazione
%         f: funzione integranda
% call: [ITrapComp] = TrapezioComposta(N,a,b,f)
% Output: Itrap: valore approssimato dell'integrale
h = (b-a)/N;             % passo dell'integrazione
x = a:h:b; 
x = x';                  % nodi di quadratura
w = ones(N+1,1);         % pesi di quadratura
w(1) = 0.5; w(N+1) = 0.5;
w = w*h;
fx = feval(f,x);         % valutatione funzionale sui nodi
ITrapComp = w'*fx;       % calcolo dell'integrale