%Esercizio2
clear all
close all
clc

% parte a)

A = [5  2  0 -1 1.5;
     2 -6  1 -3 0.5;
     0  1  4 0  2
    -1 -3 0  5 1
     1  0.5 2 1 5];


x = [1 0 0 0 1]';

b = A*x;

x0 = [3 -0.1  1 1 0]';
tol=1.e-6;
kmax = 100;

D = diag(diag(A));
invD = inv(D);
P_J = invD*(D-A);
q_J = invD*b;

E_J = eig(P_J);
if max(abs(E_J)) < 1
    disp('il metodo di Jacobi converge')
end

err_J = 10;
it_J = 0;
while it_J < kmax  && err_J > tol
    xn_J = P_J*x0 + q_J;
    err_J = norm(xn_J-x0,2)/norm(x0,2);
    it_J = it_J + 1;
    x0 = xn_J;
end
disp('l'' errore per il metodo di Jacobi e'' ')
disp(err_J)

% parte b)

C = -(triu(A)-D);
B = -(tril(A)-D);
invDB = inv(D-B);
P_GS = invDB*C;
q_GS = invDB*b;

E_GS = eig(P_GS);
if max(abs(E_GS)) < 1
    disp('il metodo di Gauss-Seidel converge')
end

it_GS = 0;
err_GS = 10;
while it_GS < kmax  && err_GS > tol
    xn_GS = P_GS*x0 + q_GS;
    err_GS = norm(xn_GS-x0,2)/norm(xn_GS,2);
    it_GS = it_GS+1;
    x0 = xn_GS;
end
disp('l'' errore per il metodo di Gauss-Seidel e'' ')
disp(err_GS)

if max(abs(E_GS))<max(abs(E_J))
    disp(['il raggio spettrale della matrice di iterazione di ',...
        'Gauss-Seidel e'' piu'' piccolo di quello della matrice di ', ...
        'iterazione di Jacobi e quindi il metodo di Gauss-Seidel ',...
        'converge piu'' velocemente'])
end

