function [zero,niter] = bisezione(f,a,b,toll,nmax)
% calcola con il metodo di bisezione lo zero approssimato di f :
%   input:  f - funzione
%           a - estremo sinistro dell'intervallo iniziale
%           b - estremo destro dell'intervallo iniziale
%           toll - errore di approssimazione consentito
%           nmax - numero massimo di iterazioni consentite
%   output: zero - valore trovato per lo zero approssimato di f
%           niter - numero di iterazioni effettuate
%nota: f va scritta come stringa che contenga anche i ; alla fine, per evitare che vengano stampati tutti i valori di eval intermedi
%esempio di chiamata: bisezione ("x^2-2;",1,2,10e-10,10)

x=a; % valore iniziale in a di f
fxa=eval(f);
x=b; % valore iniziale in b di f
fxb=eval(f);
niter=0;% mantiene il numero di iterazioni
i=abs(a-b);% i e' la misura dell'intervallo, che approssima la nostra tolleranza
%controllo che le condizioni iniziali siano corrette
if fxa.*fxb>0
disp("errore, la f non cambia segno in [a,b]");
else
%inizio ciclo
while i >= toll & niter <= nmax %finche' non ho raggiunto toll o nmax 
  niter=niter+1; %incremento numero di iterazioni
  m=(a+b)/2; %punto medio
  x=m;fxm=eval(f);%e suo valore
  %controllo se m andra' utilizzato come "nuovo" valore per b o come "nuovo" a
  if fxa.*fxm<0
    b=m; %il nuovo b e' m
    x=b; fxb=eval(f); % e ricalcolo il valore di fxb
  elseif fxm.*fxb<0
    a=m; %il nuovo a e' m
    x=a; fxa=eval(f); % e ricalcolo il valore di fxa
  else 
    disp ("trovato zero!");
    break;% in questo caso m e' uno zero, allora esco dal while
  endif;
  i=abs(a-b); %calcolo il nuovo intervallo
endwhile;
%alla fine di tutto assegno lo 0 approssimato (m) alla variabile zero
zero=m;
endif;







