function y=intrplintratti(x,xd,yd)
% y=intrplintratti(x,xd,yd)
% calcola l'interpolazione lineare a tratti dei dati presenti nei 2 vettori xd e yd
% E poi restituisce il valore di questa funzione interpolante calcolato in x.
% I valori in xd e yd sono in ordine non decrescenteare presumed
% Per punti al di fuori dell'intervallo dei dati si ha come risposta
% il valore di yd(1) per ogni x<xd(1), e yd(nd) per x>x(nd), ove nd=length(xd).

% la formula implementata e' 
% Pol=f(x(i))+(f(x(i+1))-f(x(i))/(x(i+1)-x(i)))*(x-x(i))
% per x appartenete I(i), i-esimo intervallo

y=zeros(length(x),1); 
nd=length(xd);
%se x e' maggiore (o uguale) del massimo degli x del vettore xd
%il valore di y corrispondente e' yd(nd)
if x>=xd(nd)
  y=y+yd(nd);
%se x e' minore del minimo degli x del vettore xd
%il valore di y corrispondente e' yd(1)
else
  y=y+yd(1);
endif;
%ciclo sui due vettori di valori
%costruendo per ogni intervallo (cioe' [x(i),x(i+1)], con corrispondente [y(i),y(i+1)])
%l'interpolazione lineare (retta per i 2 punti)
for i=1:nd-1
  dx=xd(i+1)-xd(i);
  if dx~=0, s=(yd(i+1)-yd(i))/dx;
  %se x si trova nell'intervallo tra xd(1) e xd(nd)
  %ne calcoliamo il valore
    if x>=xd(i) & x<xd(i+1)
      y=yd(i)+s*(x-xd(i));
    endif
  endif
endfor










