function [zero,niter] = newton(f,df,x0,toll,nmax)
% calcola con il metodo di newton lo zero approssimato di f :
%   input:  f - funzione
%           df - derivata prima di f
%           x0 - valore di partenza per le iterazioni
%           toll - errore di approssimazione consentito
%           nmax - numero massimo di iterazioni consentite
%   output: zero - valore trovato per lo zero approssimato di f
%           niter - numero di iterazioni effettuate
%
x=x0; % valore iniziale del metodo
fx=eval(f);dfx=eval(df);
niter=0;
diff=toll+1; %diff e' lo scarto fra 2 iterazioni successive, approssimazione di toll
while diff >= toll & niter <= nmax %finche' non ho raggiunto toll o nmax 
  niter=niter+1; %incremento numero di iterazioni
  diff=-fx/dfx; %calcolo a parte diff perche' rappresenta in pratica anche lo scarto (x(i)-x(i+1))
  x=x+diff; % metodo di Newton ( sarebbe x(i+1)=x(i)-(f(x(i))/df(x(i))) )
  diff=abs(diff); % scarto
  fx=eval(f);dfx=eval(df);
endwhile
zero=x;
