function runge(g)
% mostra il fenomeno di RUNGE  per l'interpolazione polinomiale.
% runge(g) mostra l'interpolante polinomiale di grado g,
% della funzione f(x)=1/(1+x^2) in [-5,5], 
% nella prima parte utilizzando nodi equispaziati, poi quelli di Chebyshev.

x = linspace(-5,5);% nodi equispaziati
f = 1./(1+x.^2);% f da provare
   
  %prima utilizzo i nodi equispaziati

  X = linspace(-5,5,g+1); Y = 1./(1+X.^2);
  c = polyfit(X,Y,g); p = polyval(c,x);

 %poi i nodi di Chebyshev

  X1 = -5*cos((2*linspace(1,g+1,g+1)-1)*pi./(2*g+2)); Y1 = 1./(1+X1.^2);
  c1 = polyfit(X1,Y1,g); p1 = polyval(c1,x);

 %stampo i due risultati
  
  plot(x,f,'b-',x,p,'r-',X,Y,'r*',X1,Y1,'c-');
