/**
 * @file cutcallback_cover.cpp
 * @brief data cutcallback implementation (function)
 */


#include "cutcallback_cover.h"

const double EPS = 1e-5;
  // as usual, we define a tolerance to cut violation, to avoid numerical issues

int myCutCallback(CEnv env, void* cbinternaldata, int wherefrom, void* cbuserdatahandle, int* useraction_p)
  // this is the fixed prototype (c-function type) for a cut callback. Parameters:
  //      - env
  //      - cbinternaldata (internal datastructures)
  //      - wherefrom (integer reporting from where this instance has been called - internal use)
  //      - cbuserdatahandle (pointer to user-defined data, as set by the "activating" CPXsetcutcallbackfunc -- see main.cpp)
  //      - a code to say what to do after (for example, "fail" if unrecoverable probles occurred)
{
	// check if solution is fractional
	*useraction_p = CPX_CALLBACK_DEFAULT; ///among other values, CPX_CALLBACK_FAIL (meaning that problems occurred so that, for example, we can stop)

	/// *IN THIS OLDER VERSION OF CPLEX*, Cplex call this function even if the LP relaxation is 
	//    integer (this allows implementing contraints generation approaches, like the 
	//    ones you have seen for TSP). Hence, we check if the current LP relaxation solution
	//    is really fractional (if the solution is integer, the separation procedure below would not
	//    identify any violated cuts: with this check we save some computational time)
	int numFracVar = 0;
	CHECKED_CPX_CALL( CPXgetcallbacknodeinfo, env, cbinternaldata, wherefrom , 
	                  0 /*current node*/, 
	                  CPX_CALLBACK_INFO_NODE_NIINF /*NIIF: number of integer infeasibility*/, 
	                  &numFracVar );
	if (numFracVar == 0) return 0;
	/* 
	 * VERSION NOTE: in the new versions of Cplex two different callbacks are defined and 
	 *  called (to be short) if the LP relaxation is fractional or integer respectively:
	 *    - CPXsetusercutcallbackfunc         (if the LP solution is fracional)
	 *    - CPXsetlazyconstraintcallbackfunc  (if the LP solution is integer)
	 *  (SEE NEW USER MANUALS!)
	 */


	// prepare user defined data handler
	CB_UserDataHandle* mydata = static_cast<CB_UserDataHandle*>(cbuserdatahandle);
	
	// get fractional solution
	int n = mydata->mkp->n;
	std::vector<double> x(n);
	CHECKED_CPX_CALL( CPXgetcallbacknodex, env, cbinternaldata, wherefrom, &x[0], 0, n - 1 );
	
	// separate
	// we separate cover inequalities for each knapsack constraint
	int m = mydata->mkp->m;
	
	//// determine the obj.func. coefficient of the separation problem (the same for every constraint)
  	std::vector<double> obj(n);
	for (int j = 0; j < n; j++) {
	  ////TODO: insert the right coefficient here
	  //// obj[j] = ... 
	}	/// the objective function of the separation problem is always the same, for every knapsack constraint
  	
	double objval = 1000;
	std::vector<double> y(n); // return values
	for (int i = 0; i < m; i++)
	{
		/// for each constraint, solve the suitable KPmin problem and, in case, add the cut
    		////TODO call mydata->solver->exec( ... )
		//// ...

		if (objval < (1.0 - EPS)) /*we want to be sure that the cover cut is violated: the larger EPS, the more we are sure!*/
		{
			// we have a violated cover
			std::vector<int> idx;
			std::vector<double> coef;
			double rhs = -1.0;
			
			//// TODO: fill arrays 'idx' and 'coef' for "addrow"-like call
			//// ...
			
			CHECKED_CPX_CALL( CPXcutcallbackadd, env, cbinternaldata, wherefrom, idx.size(), rhs, 'L', &idx[0], &coef[0], 0 );
			        // add the contraints to the "master" problem
				//	parameters: CPXCENVptr env, void * cbdata, int wherefrom, int nzcnt, double rhs, int sense, const int * cutind, const double * cutval, int purgeable
			std::cout << "Added 1 cover" << std::endl;
		}
	}
	std::cout << "round finished" << std::endl;
	*useraction_p = CPX_CALLBACK_SET;
				/// return value: means that we did something (cut added). 
				//    By doing so, the added cut is considered (for example, if we leave "*useraction_p = CPX_CALLBACK_DEFAULT;", 
				//    the added cut would be ignored)
	return 0;
}
