/*********************************************
 * OPL 12.6.1.0 Model
 * Author: luigi
 * Creation Date: Oct 11, 2017 at 9:06:22 PM
 *********************************************/

int NumLocations = ...;
setof(int) I = asSet(1..NumLocations);

float W = ...;
float F[I] = ...;
float C[I] = ...;
float R[I] = ...;
float M[i in I] = W / C[i];
int MaxLocations = ...;
int MinLocations = ...;
float MinOpen = ...;

dvar float+ x[I];
dvar boolean y[I];

maximize sum(i in I) R[i] * x[i];

subject to {
	budget: sum(i in I) ( C[i]*x[i] + F[i]*y[i] ) <= W;
	
	forall(i in I) {
		relateXtoY: x[i] <= M[i] * y[i]; 	
	}
	
	limitUB: sum(i in I) y[i] <= MaxLocations; 
	limitLB: sum(i in I) y[i] >= MinLocations;
	
	forall(i in I) {
		minOpening: x[i] >= MinOpen * y[i]; 	
	}

}
