/*********************************************
 * OPL 12.6.1.0 Model
 * Author: luigi
 * Creation Date: Oct 11, 2017 at 8:31:31 PM
 *********************************************/

int Ndest = ...;
setof(string) I = ...;		// origins
setof(int) J = asSet(1..Ndest);			// destinations

int 	O[I] = ...; 		// capacity of origin i in I
int 	D[J] = ...; 		// request of destintion j in J
float	C[I][J] = ...;		// unit transportation cost
float 	LowCost = ...;
int 	LowCostThreshold = ...;

dvar int+ x[I][J];	// how much to move from i to j ?

minimize sum (i in I, j in J) (C[i][j] * x[i][j]);

subject to {
forall ( j in J ) {
	request: sum ( i in I ) x[i][j] >= D[j];
}

forall ( i in I ) {
	capacity: sum ( j in J ) x[i][j] <= O[i];
}

//additional constraints
forall ( i in I, j in J : C[i][j] <= LowCost ) {
	lowerbound: x[i][j] >= LowCostThreshold;
}

}




 
 
