#!/usr/bin/env python
# encoding: utf-8

from docplex.mp.model import Model

# insiemi
Door = ["standard", "lussury"]
Phase = ["assemble", "paint"]

# dati
TimeHour = {"standard": {"assemble": 2, "paint": 3},
       "lussury": {"assemble": 4, "paint": 5}}
MaxProd = {"standard": 500, "lussury": 300}
Revenue = {"standard": 300, "lussury": 650}
Worker = {"assemble": 20, "paint": 30}
WeekHour = 40

def buildmodel(**kwargs):
	# Model
	mdl = Model(name='doors', **kwargs)
	# variables
	ndoor = mdl.integer_var_dict(Door, lb=0, ub=MaxProd, name="ndoor")
	mdl.ndoor = ndoor
	# objective
	mdl.maximize(mdl.sum(Revenue[p] * ndoor[p] for p in Door))
	# constraints
	for f in Phase:
		mdl.add_constraint(mdl.sum(TimeHour[p][f] * ndoor[p] for p in Door) <= Worker[f]*WeekHour, "ctTime_%s" % f)
	mdl.add_constraint(ndoor["lussury"] <= 0.5 * mdl.sum(ndoor[p] for p in Door))
	return mdl


if __name__ == '__main__':
	mdl = buildmodel()
	mdl.print_information()
	mdl.export_as_lp(path=".")
	sol = mdl.solve()
	if sol:
		mdl.report()
		for p in Door:
			print "ndoor[%s] = %g" % (p, sol[mdl.ndoor[p]])
	else:
		print "Problem could not be solved: " + mdl.get_solve_details().get_status()
