#!/usr/bin/env python
# encoding: utf-8

from docplex.mp.model import Model


def buildmodel(**kwargs):
	# Model
	mdl = Model(name='gasprod', **kwargs)
	# variables
	gas = mdl.continuous_var(name="gas")
	chloride = mdl.continuous_var(name="chloride")
	mdl.gas = gas
	mdl.chloride = chloride
	# objective
	mdl.maximize(40 * gas + 50 * chloride)
	# constraints
	mdl.add_constraint(gas + chloride <= 50)
	mdl.add_constraint(3 * gas + 4 * chloride <= 180)
	mdl.add_constraint(chloride <= 40)
	return mdl


if __name__ == '__main__':
	mdl = buildmodel()
	mdl.print_information()
	mdl.export_as_lp(path=".")
	sol = mdl.solve()
	if sol:
		mdl.report()
		print "gas = %g chloride = %g" % (sol[mdl.gas], sol[mdl.chloride])
	else:
		print "Problem could not be solved: " + mdl.get_solve_details().get_status()
