#!/usr/bin/env python
# encoding: utf-8

from docplex.mp.model import Model

# Sets
Products = ["gas", "chloride"]
Components = ["nitrogen", "hydrogen", "chlorine"]

# Data
Demand = {"gas": {"nitrogen": 1, "hydrogen": 3, "chlorine": 0},
          "chloride": {"nitrogen": 1, "hydrogen": 4, "chlorine": 1}}
Profit = {"gas": 40, "chloride": 50}
Stock = {"nitrogen": 50, "hydrogen": 180, "chlorine": 40}


def buildmodel(**kwargs):
	# Model
	mdl = Model(name='gasprod', **kwargs)
	# variables
	x = mdl.continuous_var_dict(Products, name="x")
	mdl.x = x
	# objective
	mdl.maximize(mdl.sum(Profit[p] * x[p] for p in Products))
	# constraints
	for c in Components:
		mdl.add_constraint(mdl.sum(Demand[p][c] * x[p] for p in Products) <= Stock[c], "avail_%s" % c)
	return mdl


if __name__ == '__main__':
	mdl = buildmodel()
	mdl.print_information()
	mdl.export_as_lp(path=".")
	sol = mdl.solve()
	if sol:
		mdl.report()
		for p in Products:
			print "%s = %g" % (p, sol[mdl.x[p]])
	else:
		print "Problem could not be solved: " + mdl.get_solve_details().get_status()
