#!/usr/bin/env python
# encoding: utf-8

from collections import namedtuple
from docplex.mp.model import Model

#sets
Source = ["A", "B"]
Destination = [1, 2, 3]

# dati
Cost = {
	"A": {1: 2.5, 2: 1.7, 3: 1.8},
	"B": {1: 2.5, 2: 1.8, 3: 1.4}
}

Production = {"A": 350, "B": 600}
Request = {1: 325, 2: 300, 3: 275}

def buildmodel(**kwargs):
	# Model
	mdl = Model(name='transport', **kwargs)
	# variables
	x = {(s,d): mdl.continuous_var(name="x_%s_%i"%(s,d)) for s in Source for d in Destination}
	mdl.x = x
	# objective
	mdl.minimize(mdl.sum(Cost[s][d] * x[s,d] for s in Source for d in Destination))
	# constraints
	for s in Source:
		mdl.add_constraint(mdl.sum(x[s,d] for d in Destination) <= Production[s], "prod_%s" % s)
	for d in Destination:
		mdl.add_constraint(mdl.sum(x[s,d] for s in Source) >= Request[d], "req_%i" % d)
	return mdl


if __name__ == '__main__':
	mdl = buildmodel()
	mdl.print_information()
	mdl.export_as_lp(path=".")
	sol = mdl.solve()
	if sol:
		mdl.report()
		for s in Source:
			for d in Destination:
				print "x[%s,%i] = %g" % (s, d, sol[mdl.x[s,d]])
	else:
		print "Problem could not be solved: " + mdl.get_solve_details().get_status()
