int NbWorkers = ...;
range Workers = 1..NbWorkers;
{string} Tasks = ...;
{int} Qualified[Tasks] = ...;

assert 
  forall( t in Tasks , i in Qualified[t] ) i in asSet(Workers);

int Cost[Workers] = ...;
dvar boolean Hire[Workers];

minimize 
  sum(c in Workers) Cost[c] * Hire[c];
subject to {
  forall(j in Tasks)
    ct:
      sum( c in Qualified[j] ) 
        Hire[c] >= 1;
}

{int} Crew = { c | c in Workers : Hire[c] == 1 };
execute DISPLAY {
  writeln("Crew=",Crew);
}


