{string} Sorgenti = {"A", "B"};
{string} Destinazioni = {"1", "2", "3"};

float Costo[Sorgenti][Destinazioni] = [[2.5, 1.7, 1.8], [2.5, 1.8, 1.4]];
float Domanda[Destinazioni] = [325, 300, 275];
float Produzione[Sorgenti] = [350, 600];

dvar float+ Flusso[Sorgenti][Destinazioni];

minimize
  sum( s in Sorgenti, d in Destinazioni ) 
    Costo[s][d] * Flusso[s][d];
subject to {
  forall( s in Sorgenti )
    ctProd: sum( d in Destinazioni ) Flusso[s][d] <= Produzione[s];
  forall( d in Destinazioni )
    ctDom: sum( s in Sorgenti ) Flusso[s][d] >= Domanda[d];
}

