set NODE;

param b{NODE};
param infinite_arc_cost;
param c{NODE, NODE} default infinite_arc_cost;

var x{ i in NODE , j in NODE: c[i,j] != infinite_arc_cost } binary;

minimize path_cost: 
	sum { i in NODE , j in NODE: c[i,j] != infinite_arc_cost } c[i,j] * x[i,j];

s.t. balance { v in NODE }:
	 sum { i in NODE: c[i,v] != infinite_arc_cost } x[i,v] 
	 	- sum { j in NODE: c[v,j] != infinite_arc_cost } x[v,j] 
	 	= b[v];
