### TRASPORTO FRIGO: modello ###
################################

#INSIEMI
set S; 			#insieme degli stabilimenti
set M; 			#insieme dei magazzini

#PARAMETRI
param costo{S,M};	#costi unitari di trasporto
param capacita{S};	#produzione stabilimenti
param richiesta{M};	#richiesta magazzini

#VARIABILI
var x{S,M}	>= 0	integer;	#numero frigo trasportati

#FUNZIONE OBIETTIVO
minimize 	costo_totale:	sum {i in S, j in M} costo[i,j] * x[i,j];

#VINCOLI
subject to	produzione {i in S}:
		sum{j in M} x[i,j] <= capacita[i];

subject to	domanda {j in M}:
		sum{i in S} x[i,j] >= richiesta[j];
