
/* Generated By:JavaCC: Do not edit this line. CmdParserPlayer.java */
package atan.parser;

//~--- non-JDK imports --------------------------------------------------------

import atan.model.ActionsPlayer;
import atan.model.ControllerPlayer;
import atan.model.enums.Errors;
import atan.model.enums.Ok;
import atan.model.enums.PlayMode;
import atan.model.enums.RefereeMessage;
import atan.model.enums.ViewAngle;
import atan.model.enums.ViewQuality;
import atan.model.enums.Warning;

//~--- JDK imports ------------------------------------------------------------

import java.io.StringReader;

/**
 *
 * @author author
 */
public class CmdParserPlayer implements CmdParserPlayerConstants {
    static private int[] jj_la1_0;
    static private int[] jj_la1_1;
    static private int[] jj_la1_2;

    static {
        jj_la1_init_0();
        jj_la1_init_1();
        jj_la1_init_2();
    }

    private int                    jj_gc         = 0;
    private int                    jj_kind       = -1;
    final private int[]            jj_la1        = new int[0];
    final private JJCalls[]        jj_2_rtns     = new JJCalls[141];
    private int[]                  jj_lasttokens = new int[100];
    private boolean                jj_rescan     = false;
    final private LookaheadSuccess jj_ls         = new LookaheadSuccess();
    private java.util.List<int[]>  jj_expentries = new java.util.ArrayList<int[]>();
    ControllerPlayer               controller;
    private int                    jj_endpos;
    private int[]                  jj_expentry;
    private int                    jj_gen;
    SimpleCharStream               jj_input_stream;
    private int                    jj_la;

    /** Next token. */
    public Token  jj_nt;
    private int   jj_ntk;
    private Token jj_scanpos, jj_lastpos;
    ActionsPlayer player;

    /** Current token. */
    public Token token;

    /** Generated Token Manager. */
    public CmdParserPlayerTokenManager token_source;

    /**
     * Constructor with generated Token Manager.
     * @param tm
     */
    public CmdParserPlayer(CmdParserPlayerTokenManager tm) {
        token_source = tm;
        token        = new Token();
        jj_ntk       = -1;
        jj_gen       = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Constructor with InputStream.
     * @param stream
     */
    public CmdParserPlayer(java.io.InputStream stream) {
        this(stream, null);
    }

    /**
     * Constructor.
     * @param stream
     */
    public CmdParserPlayer(java.io.Reader stream) {
        jj_input_stream = new SimpleCharStream(stream, 1, 1);
        token_source    = new CmdParserPlayerTokenManager(jj_input_stream);
        token           = new Token();
        jj_ntk          = -1;
        jj_gen          = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Constructor with InputStream and supplied encoding
     * @param stream
     * @param encoding
     */
    public CmdParserPlayer(java.io.InputStream stream, String encoding) {
        try {
            jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        } catch (java.io.UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source = new CmdParserPlayerTokenManager(jj_input_stream);
        token        = new Token();
        jj_ntk       = -1;
        jj_gen       = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     *
     * @param cmd
     * @param controller
     * @param player
     * @throws ParseException
     */
    public void parseSeeCommand(String cmd, ControllerPlayer controller, ActionsPlayer player) throws ParseException {
        ReInit(new StringReader(cmd));
        this.controller = controller;
        this.player     = player;
        startSeeCommand();
    }

    /**
     *
     * @param cmd
     * @param controller
     * @param player
     * @throws ParseException
     */
    public void parseHearCommand(String cmd, ControllerPlayer controller, ActionsPlayer player) throws ParseException {
        ReInit(new StringReader(cmd));
        this.controller = controller;
        this.player     = player;
        startHearCommand();
    }

    /**
     *
     * @param cmd
     * @param controller
     * @param player
     * @throws ParseException
     */
    public void parseInitCommand(String cmd, ControllerPlayer controller, ActionsPlayer player) throws ParseException {
        ReInit(new StringReader(cmd));
        this.controller = controller;
        this.player     = player;
        startInitCommand();
    }

    /**
     *
     * @param cmd
     * @param controller
     * @param player
     * @throws ParseException
     */
    public void parseErrorCommand(String cmd, ControllerPlayer controller, ActionsPlayer player) throws ParseException {
        ReInit(new StringReader(cmd));
        this.controller = controller;
        this.player     = player;
        startErrorCommand();
    }

    /**
     *
     * @param cmd
     * @param controller
     * @param player
     * @throws ParseException
     */
    public void parseSenseBodyCommand(String cmd, ControllerPlayer controller, ActionsPlayer player)
            throws ParseException {
        ReInit(new StringReader(cmd));
        this.controller = controller;
        this.player     = player;
        startSenseBodyCommand();
    }

    /**
     *
     * @param cmd
     * @param controller
     * @param player
     * @throws ParseException
     */
    public void parseOkCommand(String cmd, ControllerPlayer controller, ActionsPlayer player) throws ParseException {
        ReInit(new StringReader(cmd));
        this.controller = controller;
        this.player     = player;
        startOkCommand();
    }

    /**
     *
     * @param cmd
     * @param controller
     * @param player
     * @throws ParseException
     */
    public void parseWarningCommand(String cmd, ControllerPlayer controller, ActionsPlayer player)
            throws ParseException {
        ReInit(new StringReader(cmd));
        this.controller = controller;
        this.player     = player;
        startWarningCommand();
    }

    /**
     *
     * @param cmd
     * @param controller
     * @param player
     * @throws ParseException
     */
    public void parseServerParamCommand(String cmd, ControllerPlayer controller, ActionsPlayer player)
            throws ParseException {
        ReInit(new StringReader(cmd));
        this.controller = controller;
        this.player     = player;
        startServerParamCommand();
    }

    /**
     *
     * @param cmd
     * @param controller
     * @param player
     * @throws ParseException
     */
    public void parsePlayerParamCommand(String cmd, ControllerPlayer controller, ActionsPlayer player)
            throws ParseException {
        ReInit(new StringReader(cmd));
        this.controller = controller;
        this.player     = player;
        startPlayerParamCommand();
    }

    /**
     *
     * @param cmd
     * @param controller
     * @param player
     * @throws ParseException
     */
    public void parsePlayerTypeCommand(String cmd, ControllerPlayer controller, ActionsPlayer player)
            throws ParseException {
        ReInit(new StringReader(cmd));
        this.controller = controller;
        this.player     = player;
        startPlayerTypeCommand();
    }

    /**
     *
     * @param cmd
     * @param controller
     * @param player
     * @throws ParseException
     */
    public void parseChangePlayerTypeCommand(String cmd, ControllerPlayer controller, ActionsPlayer player)
            throws ParseException {
        ReInit(new StringReader(cmd));
        this.controller = controller;
        this.player     = player;
        startChangePlayerTypeCommand();
    }

    /**
     *
     * @throws ParseException
     */
    final public void startHearCommand() throws ParseException {
        Token num;
        Token msg;
        jj_consume_token(NUM);
        jj_consume_token(SEP);
        if (jj_2_1(2)) {
            jj_consume_token(SELF);
        } else if (jj_2_2(2)) {
            jj_consume_token(REFEREE);
            jj_consume_token(SEP);
            hearReferee();
        } else if (jj_2_3(2)) {
            num = jj_consume_token(NUM);
            jj_consume_token(SEP);
            msg = jj_consume_token(NAM);
            Double dNum = new Double(num.image);
            controller.infoHearPlayer(dNum.doubleValue(), msg.image);
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    /**
     *
     * @throws ParseException
     */
    final public void hearReferee() throws ParseException {
        PlayMode       playMode       = null;
        RefereeMessage refereeMessage = null;
        if (jj_2_4(2)) {
            playMode = playMode();
            controller.infoHearPlayMode(playMode);
        } else if (jj_2_5(2)) {
            refereeMessage = refereeMessage();
            // controller.infoHearReferee(refereeMessage);
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
    }

    /**
     *
     * @throws ParseException
     */
    final public void startInitCommand() throws ParseException {
        Token    side     = null;
        PlayMode playMode = null;
        Token    num;
        if (jj_2_6(2)) {
            side = jj_consume_token(L);
        } else if (jj_2_7(2)) {
            side = jj_consume_token(R);
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        player.setTeamEast(side.image.charAt(0) == 'r');
        jj_consume_token(SEP);
        num = jj_consume_token(NUM);
        Integer iNum = new Integer(num.image);
        player.setNumber(iNum.intValue());
        jj_consume_token(SEP);
        playMode = playMode();
        controller.infoHearPlayMode(playMode);
    }

    /**
     *
     * @throws ParseException
     */
    final public void startSenseBodyCommand() throws ParseException {
        Token viewModeQual     = null;
        Token viewModeAngle    = null;
        Token stamina          = null;
        Token effort           = null;
        Token amountOfSpeed    = null;
        Token directionOfSpeed = null;
        Token headAngle        = null;
        Token turnNeck         = null;
        Token catchCount       = null;
        Token moveCount        = null;
        Token changeView       = null;
        Token kick             = null;
        Token dash             = null;
        Token turn             = null;
        Token say              = null;
        Token unknown          = null;
        jj_consume_token(NUM);
        jj_consume_token(SEP);
        jj_consume_token(OB);
        jj_consume_token(VIEW_MODE);
        jj_consume_token(SEP);
        if (jj_2_8(2)) {
            viewModeQual = jj_consume_token(HIGH);
        } else if (jj_2_9(2)) {
            viewModeQual = jj_consume_token(LOW);
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        jj_consume_token(SEP);
        if (jj_2_10(2)) {
            viewModeAngle = jj_consume_token(WIDE);
        } else if (jj_2_11(2)) {
            viewModeAngle = jj_consume_token(NARROW);
        } else if (jj_2_12(2)) {
            viewModeAngle = jj_consume_token(NORMAL);
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        jj_consume_token(CB);
        jj_consume_token(SEP);
        jj_consume_token(OB);
        jj_consume_token(STAMINA);
        jj_consume_token(SEP);
        stamina = jj_consume_token(NUM);
        jj_consume_token(SEP);
        unknown = jj_consume_token(NUM);
        jj_consume_token(SEP);
        effort = jj_consume_token(NUM);
        jj_consume_token(CB);
        jj_consume_token(SEP);
        jj_consume_token(OB);
        jj_consume_token(SPEED);
        jj_consume_token(SEP);
        amountOfSpeed = jj_consume_token(NUM);
        jj_consume_token(SEP);
        directionOfSpeed = jj_consume_token(NUM);
        jj_consume_token(CB);
        jj_consume_token(SEP);
        jj_consume_token(OB);
        jj_consume_token(HEAD_ANGLE);
        jj_consume_token(SEP);
        headAngle = jj_consume_token(NUM);
        jj_consume_token(CB);
        jj_consume_token(SEP);
        jj_consume_token(OB);
        jj_consume_token(KICK);
        jj_consume_token(SEP);
        kick = jj_consume_token(NUM);
        jj_consume_token(CB);
        jj_consume_token(SEP);
        jj_consume_token(OB);
        jj_consume_token(DASH);
        jj_consume_token(SEP);
        dash = jj_consume_token(NUM);
        jj_consume_token(CB);
        jj_consume_token(SEP);
        jj_consume_token(OB);
        jj_consume_token(TURN);
        jj_consume_token(SEP);
        turn = jj_consume_token(NUM);
        jj_consume_token(CB);
        jj_consume_token(SEP);
        jj_consume_token(OB);
        jj_consume_token(SAY);
        jj_consume_token(SEP);
        say = jj_consume_token(NUM);
        jj_consume_token(CB);
        jj_consume_token(SEP);
        jj_consume_token(OB);
        jj_consume_token(TURN_NECK);
        jj_consume_token(SEP);
        turnNeck = jj_consume_token(NUM);
        jj_consume_token(CB);
        jj_consume_token(SEP);
        jj_consume_token(OB);
        jj_consume_token(CATCH);
        jj_consume_token(SEP);
        catchCount = jj_consume_token(NUM);
        jj_consume_token(CB);
        jj_consume_token(SEP);
        jj_consume_token(OB);
        jj_consume_token(MOVE);
        jj_consume_token(SEP);
        moveCount = jj_consume_token(NUM);
        jj_consume_token(CB);
        jj_consume_token(SEP);
        jj_consume_token(OB);
        jj_consume_token(CHANGE_VIEW);
        jj_consume_token(SEP);
        changeView = jj_consume_token(NUM);
        jj_consume_token(CB);
        ViewQuality iViewModeQual   = null;
        ViewAngle   iViewModeAngle  = null;
        Double      dStamina        = new Double(stamina.image);
        Double      dEffort         = new Double(effort.image);
        Double      dUnknown        = new Double(unknown.image);
        Double      dSpeedAmount    = new Double(amountOfSpeed.image);
        Double      dSpeedDirection = new Double(directionOfSpeed.image);
        Double      dHeadAngle      = new Double(headAngle.image);
        Integer     iKick           = new Integer(kick.image);
        Integer     iDash           = new Integer(dash.image);
        Integer     iTurn           = new Integer(turn.image);
        Integer     iSay            = new Integer(say.image);
        Integer     iTurnNeck       = new Integer(turnNeck.image);
        Integer     iCatch          = new Integer(catchCount.image);
        Integer     iMove           = new Integer(moveCount.image);
        Integer     iChangeView     = new Integer(changeView.image);
        switch (viewModeQual.image.charAt(0)) {
            case 'h' :
                iViewModeQual = ViewQuality.HIGH;
                break;
            case 'l' :
                iViewModeQual = ViewQuality.LOW;
                break;
        }
        switch (viewModeAngle.image.charAt(1)) {
            case 'i' :
                iViewModeAngle = ViewAngle.WIDE;
                break;
            case 'a' :
                iViewModeAngle = ViewAngle.NARROW;
                break;
            case 'o' :
                iViewModeAngle = ViewAngle.NORMAL;
                break;
        }
        controller.infoSenseBody(iViewModeQual, iViewModeAngle, dStamina.doubleValue(), dUnknown.doubleValue(),
                                 dEffort.doubleValue(), dSpeedAmount.doubleValue(), dSpeedDirection.doubleValue(),
                                 dHeadAngle.doubleValue(), iKick.intValue(), iDash.intValue(), iTurn.intValue(),
                                 iSay.intValue(), iTurnNeck.intValue(), iCatch.intValue(), iMove.intValue(),
                                 iChangeView.intValue());
    }

//  Basic commands

    /**
     *
     * @throws ParseException
     */
    final public void startErrorCommand() throws ParseException {
        Errors error = null;
        error = error();
        controller.infoHearError(error);
    }

    /**
     *
     * @throws ParseException
     */
    final public void startOkCommand() throws ParseException {
        Ok ok = null;
        ok = ok();
        controller.infoHearOk(ok);
    }

    /**
     *
     * @throws ParseException
     */
    final public void startWarningCommand() throws ParseException {
        Warning warning = null;
        warning = warning();
        controller.infoHearWarning(warning);
    }

//  Commands still to implement...

    /**
     *
     * @throws ParseException
     */
    final public void startServerParamCommand() throws ParseException {}

    /**
     *
     * @throws ParseException
     */
    final public void startPlayerParamCommand() throws ParseException {}

    /**
     *
     * @throws ParseException
     */
    final public void startPlayerTypeCommand() throws ParseException {}

    /**
     *
     * @throws ParseException
     */
    final public void startChangePlayerTypeCommand() throws ParseException {}

//  Most important command!

    /**
     *
     * @throws ParseException
     */
    final public void startSeeCommand() throws ParseException {
        jj_consume_token(NUM);
        if (jj_2_15(2)) {
            jj_consume_token(SEP);
            label_1:
            while (true) {
                jj_consume_token(OB);
                objInfo();
                jj_consume_token(CB);
                if (jj_2_13(2)) {
                    jj_consume_token(SEP);
                } else {
                    ;
                }
                if (jj_2_14(2)) {
                    ;
                } else {
                    break label_1;
                }
            }
        } else {
            ;
        }
    }

//  Get object details.

    /**
     *
     * @throws ParseException
     */
    final public void objInfo() throws ParseException {
        ObjName name;
        Token   p1 = null;
        Token   p2 = null;
        Token   p3 = null;
        Token   p4 = null;
        Token   p5 = null;
        Token   p6 = null;
        jj_consume_token(OB);
        name = objName();
        jj_consume_token(CB);
        jj_consume_token(SEP);
        if (jj_2_17(2)) {
            p1 = jj_consume_token(NUM);
            if (jj_2_16(2)) {
                jj_consume_token(SEP);
            } else {
                ;
            }
        } else {
            ;
        }
        if (jj_2_19(2)) {
            p2 = jj_consume_token(NUM);
            if (jj_2_18(2)) {
                jj_consume_token(SEP);
            } else {
                ;
            }
        } else {
            ;
        }
        if (jj_2_21(2)) {
            p3 = jj_consume_token(NUM);
            if (jj_2_20(2)) {
                jj_consume_token(SEP);
            } else {
                ;
            }
        } else {
            ;
        }
        if (jj_2_23(2)) {
            p4 = jj_consume_token(NUM);
            if (jj_2_22(2)) {
                jj_consume_token(SEP);
            } else {
                ;
            }
        } else {
            ;
        }
        if (jj_2_25(2)) {
            p5 = jj_consume_token(NUM);
            if (jj_2_24(2)) {
                jj_consume_token(SEP);
            } else {
                ;
            }
        } else {
            ;
        }
        if (jj_2_27(2)) {
            p6 = jj_consume_token(NUM);
            if (jj_2_26(2)) {
                jj_consume_token(SEP);
            } else {
                ;
            }
        } else {
            ;
        }

        // HeadFacingDir
        Double dDistance      = 0.0;
        Double dDirection     = 0.0;
        Double dDistChange    = 0.0;
        Double dDirChange     = 0.0;
        Double dBodyFacingDir = 0.0;
        Double dHeadFacingDir = 0.0;

        // Stop null pointer errors.
        if ((p1 != null) && (p2 == null)) {
            dDirection = new Double(p1.toString());
        } else {
            if (p1 != null) {
                dDistance = new Double(p1.toString());
            } else {
                dDistance = new Double(0);
            }
            if (p2 != null) {
                dDirection = new Double(p2.toString());
            } else {
                dDirection = new Double(0);
            }
            if (p3 != null) {
                dDistChange = new Double(p3.toString());
            } else {
                dDistChange = new Double(0);
            }
            if (p4 != null) {
                dDirChange = new Double(p4.toString());
            } else {
                dDirChange = new Double(0);
            }
            if (p5 != null) {
                dBodyFacingDir = new Double(p5.toString());
            } else {
                dBodyFacingDir = new Double(0);
            }
            if (p6 != null) {
                dHeadFacingDir = new Double(p6.toString());
            } else {
                dHeadFacingDir = new Double(0);
            }
        }

        // East-West dependency
        if (player.isTeamEast()) {
            name.infoSeeFromEast(controller, dDistance.doubleValue(), dDirection.doubleValue(),
                                 dDistChange.doubleValue(), dDirChange.doubleValue(), dBodyFacingDir.doubleValue(),
                                 dHeadFacingDir.doubleValue());
        } else {
            name.infoSeeFromWest(controller, dDistance.doubleValue(), dDirection.doubleValue(),
                                 dDistChange.doubleValue(), dDirChange.doubleValue(), dBodyFacingDir.doubleValue(),
                                 dHeadFacingDir.doubleValue());
        }
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public ObjName objName() throws ParseException {
        Token   name;
        Token   num;
        ObjName objName = null;
        if (jj_2_32(2)) {
            jj_consume_token(P);
            if (jj_2_29(2)) {
                if (jj_2_28(2)) {
                    jj_consume_token(SEP);
                } else {
                    ;
                }
                objName = objNamePlayer();
            } else {
                ;
            }
            if (objName == null) {
                if (true) {
                    return new ObjNameNull();
                }
            } else {
                if (true) {
                    return objName;
                }
            }
        } else if (jj_2_33(2)) {
            jj_consume_token(B);
            {
                if (true) {
                    return new ObjNameBall();
                }
            }
        } else if (jj_2_34(2)) {
            jj_consume_token(FLAG);
            if (jj_2_30(2)) {
                jj_consume_token(SEP);
                objName = objNameFlag();
            } else {
                ;
            }
            if (objName == null) {
                if (true) {
                    return new ObjNameNull();
                }
            } else {
                if (true) {
                    return objName;
                }
            }
        } else if (jj_2_35(2)) {
            jj_consume_token(L);
            jj_consume_token(SEP);
            objName = objNameLine();
            {
                if (true) {
                    return objName;
                }
            }
        } else if (jj_2_36(2)) {
            jj_consume_token(GOAL);
            if (jj_2_31(2)) {
                jj_consume_token(SEP);
                objName = objNameFlagGoal();
            } else {
                ;
            }
            if (objName == null) {
                if (true) {
                    return new ObjNameNull();
                }
            } else {
                if (true) {
                    return objName;
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public ObjName objNamePlayer() throws ParseException {
        Token   name    = null;
        Token   num     = null;
        Token   goalie  = null;
        ObjName objName = null;
        if (jj_2_39(2)) {
            name = jj_consume_token(NAM);
            if (jj_2_37(2)) {
                jj_consume_token(SEP);
                num = jj_consume_token(NUM);
            } else {
                ;
            }
            if (jj_2_38(2)) {
                jj_consume_token(SEP);
                goalie = jj_consume_token(GOALIE);
            } else {
                ;
            }
            Integer iNum;

            // Assign seen player number.
            if (num == null) {
                iNum = new Integer(-1);
            } else {
                iNum = new Integer(num.toString());
            }

            // Work out of one of ours or theirs.
            if (name.toString().equals(player.getTeamName())) {
                if (goalie == null) {
                    if (player.isTeamEast()) {
                        if (true) {
                            return new ObjNamePlayerEast(iNum.intValue(), false);
                        }
                    } else {
                        if (true) {
                            return new ObjNamePlayerWest(iNum.intValue(), false);
                        }
                    }
                } else {
                    if (player.isTeamEast()) {
                        if (true) {
                            return new ObjNamePlayerEast(iNum.intValue(), true);
                        }
                    } else {
                        if (true) {
                            return new ObjNamePlayerWest(iNum.intValue(), true);
                        }
                    }
                }
            } else {
                if (goalie == null) {
                    if (player.isTeamEast()) {
                        if (true) {
                            return new ObjNamePlayerWest(iNum.intValue(), false);
                        }
                    } else {
                        if (true) {
                            return new ObjNamePlayerEast(iNum.intValue(), false);
                        }
                    }
                } else {
                    if (player.isTeamEast()) {
                        if (true) {
                            return new ObjNamePlayerWest(iNum.intValue(), true);
                        }
                    } else {
                        if (true) {
                            return new ObjNamePlayerEast(iNum.intValue(), true);
                        }
                    }
                }
            }
        } else if (jj_2_40(2)) {
            jj_consume_token(L);
            jj_consume_token(SEP);
            num = jj_consume_token(NUM);
            Integer iNum = new Integer(num.toString());
            if (goalie == null) {
                {
                    if (true) {
                        return new ObjNamePlayerWest(iNum.intValue(), false);
                    }
                }
            } else {
                {
                    if (true) {
                        return new ObjNamePlayerWest(iNum.intValue(), true);
                    }
                }
            }
        } else if (jj_2_41(2)) {
            jj_consume_token(R);
            jj_consume_token(SEP);
            num = jj_consume_token(NUM);
            Integer iNum = new Integer(num.toString());
            if (goalie == null) {
                {
                    if (true) {
                        return new ObjNamePlayerEast(iNum.intValue(), false);
                    }
                }
            } else {
                {
                    if (true) {
                        return new ObjNamePlayerEast(iNum.intValue(), true);
                    }
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public ObjName objNameFlag() throws ParseException {
        ObjName objName = null;
        if (jj_2_43(2)) {
            jj_consume_token(C);
            if (jj_2_42(2)) {
                jj_consume_token(SEP);
                objName = objNameFlagCenter();
            } else {
                ;
            }
            if (objName == null) {
                if (true) {
                    return new ObjNameFlagCenter('c');
                }
            } else {
                if (true) {
                    return objName;
                }
            }
        } else if (jj_2_44(2)) {
            jj_consume_token(P);
            jj_consume_token(SEP);
            objName = objNameFlagPenalty();
            {
                if (true) {
                    return objName;
                }
            }
        } else if (jj_2_45(2)) {
            jj_consume_token(L);
            jj_consume_token(SEP);
            objName = objNameFlagLeft();
            {
                if (true) {
                    return objName;
                }
            }
        } else if (jj_2_46(2)) {
            jj_consume_token(R);
            jj_consume_token(SEP);
            objName = objNameFlagRight();
            {
                if (true) {
                    return objName;
                }
            }
        } else if (jj_2_47(2)) {
            jj_consume_token(T);
            jj_consume_token(SEP);
            objName = objNameFlagTop();
            {
                if (true) {
                    return objName;
                }
            }
        } else if (jj_2_48(2)) {
            jj_consume_token(B);
            jj_consume_token(SEP);
            objName = objNameFlagBottom();
            {
                if (true) {
                    return objName;
                }
            }
        } else if (jj_2_49(2)) {
            jj_consume_token(GOAL);
            jj_consume_token(SEP);
            objName = objNameFlagGoal();
            {
                if (true) {
                    return objName;
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public ObjName objNameFlagGoal() throws ParseException {
        Token q = null;
        if (jj_2_56(2)) {
            jj_consume_token(L);
            if (jj_2_52(2)) {
                if (jj_2_50(2)) {
                    jj_consume_token(SEP);
                    q = jj_consume_token(T);
                } else if (jj_2_51(2)) {
                    jj_consume_token(SEP);
                    q = jj_consume_token(B);
                } else {
                    jj_consume_token(-1);
                    throw new ParseException();
                }
            } else {
                ;
            }
            if (q == null) {
                if (true) {
                    return new ObjNameFlagGoalLeft('c');
                }
            } else {
                if (true) {
                    return new ObjNameFlagGoalLeft(q.image.charAt(0));
                }
            }
        } else if (jj_2_57(2)) {
            jj_consume_token(R);
            if (jj_2_55(2)) {
                if (jj_2_53(2)) {
                    jj_consume_token(SEP);
                    q = jj_consume_token(T);
                } else if (jj_2_54(2)) {
                    jj_consume_token(SEP);
                    q = jj_consume_token(B);
                } else {
                    jj_consume_token(-1);
                    throw new ParseException();
                }
            } else {
                ;
            }
            if (q == null) {
                if (true) {
                    return new ObjNameFlagGoalRight('c');
                }
            } else {
                if (true) {
                    return new ObjNameFlagGoalRight(q.image.charAt(0));
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public ObjName objNameLine() throws ParseException {
        ObjName objName;
        if (jj_2_58(2)) {
            jj_consume_token(T);
            {
                if (true) {
                    return new ObjNameLine('t');
                }
            }
        } else if (jj_2_59(2)) {
            jj_consume_token(B);
            {
                if (true) {
                    return new ObjNameLine('b');
                }
            }
        } else if (jj_2_60(2)) {
            jj_consume_token(R);
            {
                if (true) {
                    return new ObjNameLine('r');
                }
            }
        } else if (jj_2_61(2)) {
            jj_consume_token(L);
            {
                if (true) {
                    return new ObjNameLine('l');
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public ObjName objNameFlagCenter() throws ParseException {
        ObjName objName;
        if (jj_2_62(2)) {
            jj_consume_token(T);
            {
                if (true) {
                    return new ObjNameFlagCenter('t');
                }
            }
        } else if (jj_2_63(2)) {
            jj_consume_token(B);
            {
                if (true) {
                    return new ObjNameFlagCenter('b');
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public ObjName objNameFlagLeft() throws ParseException {
        ObjName objName;
        Token   num = null;
        if (jj_2_66(2)) {
            jj_consume_token(T);
            if (jj_2_64(2)) {
                jj_consume_token(SEP);
                num = jj_consume_token(NUM);
            } else {
                ;
            }
            if (num == null) {
                if (true) {
                    return new ObjNameFlagCornerLeft('t');
                }
            } else {
                Integer iNum = new Integer(num.toString());
                {
                    if (true) {
                        return new ObjNameFlagLeft('t', iNum.intValue());
                    }
                }
            }
        } else if (jj_2_67(2)) {
            jj_consume_token(B);
            if (jj_2_65(2)) {
                jj_consume_token(SEP);
                num = jj_consume_token(NUM);
            } else {
                ;
            }
            if (num == null) {
                if (true) {
                    return new ObjNameFlagCornerLeft('b');
                }
            } else {
                Integer iNum = new Integer(num.toString());
                {
                    if (true) {
                        return new ObjNameFlagLeft('b', iNum.intValue());
                    }
                }
            }
        } else if (jj_2_68(2)) {
            jj_consume_token(NUM);
            {
                if (true) {
                    return new ObjNameFlagLeft('0', -1);
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public ObjName objNameFlagRight() throws ParseException {
        ObjName objName;
        Token   num = null;
        if (jj_2_71(2)) {
            jj_consume_token(T);
            if (jj_2_69(2)) {
                jj_consume_token(SEP);
                num = jj_consume_token(NUM);
            } else {
                ;
            }
            if (num == null) {
                if (true) {
                    return new ObjNameFlagCornerRight('t');
                }
            } else {
                Integer iNum = new Integer(num.toString());
                {
                    if (true) {
                        return new ObjNameFlagRight('t', iNum.intValue());
                    }
                }
            }
        } else if (jj_2_72(2)) {
            jj_consume_token(B);
            if (jj_2_70(2)) {
                jj_consume_token(SEP);
                num = jj_consume_token(NUM);
            } else {
                ;
            }
            if (num == null) {
                if (true) {
                    return new ObjNameFlagCornerRight('b');
                }
            } else {
                Integer iNum = new Integer(num.toString());
                {
                    if (true) {
                        return new ObjNameFlagRight('b', iNum.intValue());
                    }
                }
            }
        } else if (jj_2_73(2)) {
            jj_consume_token(NUM);
            {
                if (true) {
                    return new ObjNameFlagRight('0', -1);
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public ObjName objNameFlagTop() throws ParseException {
        ObjName objName;
        Token   num;
        if (jj_2_74(2)) {
            jj_consume_token(R);
            jj_consume_token(SEP);
            num = jj_consume_token(NUM);
            Integer iNum = new Integer(num.toString());
            {
                if (true) {
                    return new ObjNameFlagTop('r', iNum.intValue());
                }
            }
        } else if (jj_2_75(2)) {
            jj_consume_token(L);
            jj_consume_token(SEP);
            num = jj_consume_token(NUM);
            Integer iNum = new Integer(num.toString());
            {
                if (true) {
                    return new ObjNameFlagTop('l', iNum.intValue());
                }
            }
        } else if (jj_2_76(2)) {
            jj_consume_token(NUM);
            {
                if (true) {
                    return new ObjNameFlagTop('0', -1);
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public ObjName objNameFlagBottom() throws ParseException {
        ObjName objName;
        Token   num;
        if (jj_2_77(2)) {
            jj_consume_token(R);
            jj_consume_token(SEP);
            num = jj_consume_token(NUM);
            Integer iNum = new Integer(num.toString());
            {
                if (true) {
                    return new ObjNameFlagBottom('r', iNum.intValue());
                }
            }
        } else if (jj_2_78(2)) {
            jj_consume_token(L);
            jj_consume_token(SEP);
            num = jj_consume_token(NUM);
            Integer iNum = new Integer(num.toString());
            {
                if (true) {
                    return new ObjNameFlagBottom('l', iNum.intValue());
                }
            }
        } else if (jj_2_79(2)) {
            jj_consume_token(NUM);
            {
                if (true) {
                    return new ObjNameFlagBottom('0', -1);
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public ObjName objNameFlagPenalty() throws ParseException {
        ObjName objName = null;
        if (jj_2_82(2)) {
            jj_consume_token(L);
            if (jj_2_80(2)) {
                jj_consume_token(SEP);
                objName = objNameFlagPenaltyWest();
            } else {
                ;
            }
            if (objName == null) {
                if (true) {
                    return new ObjNameFlagPenaltyWest('c');
                }
            } else {
                if (true) {
                    return objName;
                }
            }
        } else if (jj_2_83(2)) {
            jj_consume_token(R);
            if (jj_2_81(2)) {
                jj_consume_token(SEP);
                objName = objNameFlagPenaltyEast();
            } else {
                ;
            }
            if (objName == null) {
                if (true) {
                    return new ObjNameFlagPenaltyEast('c');
                }
            } else {
                if (true) {
                    return objName;
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public ObjName objNameFlagPenaltyWest() throws ParseException {
        ObjName objName;
        if (jj_2_84(2)) {
            jj_consume_token(T);
            {
                if (true) {
                    return new ObjNameFlagPenaltyWest('t');
                }
            }
        } else if (jj_2_85(2)) {
            jj_consume_token(B);
            {
                if (true) {
                    return new ObjNameFlagPenaltyWest('b');
                }
            }
        } else if (jj_2_86(2)) {
            jj_consume_token(C);
            {
                if (true) {
                    return new ObjNameFlagPenaltyWest('c');
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public ObjName objNameFlagPenaltyEast() throws ParseException {
        ObjName objName;
        if (jj_2_87(2)) {
            jj_consume_token(T);
            {
                if (true) {
                    return new ObjNameFlagPenaltyEast('t');
                }
            }
        } else if (jj_2_88(2)) {
            jj_consume_token(B);
            {
                if (true) {
                    return new ObjNameFlagPenaltyEast('b');
                }
            }
        } else if (jj_2_89(2)) {
            jj_consume_token(C);
            {
                if (true) {
                    return new ObjNameFlagPenaltyEast('c');
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

//  Enum Switches

    /**
     *
     * @return
     * @throws ParseException
     */
    final public Warning warning() throws ParseException {
        if (jj_2_90(2)) {
            jj_consume_token(NO_TEAM_FOUND);
            {
                if (true) {
                    return Warning.NO_TEAM_FOUND;
                }
            }
        } else if (jj_2_91(2)) {
            jj_consume_token(NO_SUCH_PLAYER);
            {
                if (true) {
                    return Warning.NO_SUCH_PLAYER;
                }
            }
        } else if (jj_2_92(2)) {
            jj_consume_token(CANNOT_SUB_WHILE_PLAYON);
            {
                if (true) {
                    return Warning.CANNOT_SUB_WHILE_PLAYON;
                }
            }
        } else if (jj_2_93(2)) {
            jj_consume_token(NO_SUBS_LEFT);
            {
                if (true) {
                    return Warning.NO_SUBS_LEFT;
                }
            }
        } else if (jj_2_94(2)) {
            jj_consume_token(MAX_OF_THAT_TYPE_ON_FIELD);
            {
                if (true) {
                    return Warning.MAX_OF_THAT_TYPE_ON_FIELD;
                }
            }
        } else if (jj_2_95(2)) {
            jj_consume_token(CANNOT_CHANGE_GOALIE);
            {
                if (true) {
                    return Warning.CANNOT_CHANGE_GOALIE;
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public Ok ok() throws ParseException {
        if (jj_2_96(2)) {
            jj_consume_token(MOVE);
            {
                if (true) {
                    return Ok.MOVE;
                }
            }
        } else if (jj_2_97(2)) {
            jj_consume_token(CHANGE_MODE);
            {
                if (true) {
                    return Ok.CHANGE_MODE;
                }
            }
        } else if (jj_2_98(2)) {
            jj_consume_token(CHECK_BALL);
            {
                if (true) {
                    return Ok.CHECK_BALL;
                }
            }
        } else if (jj_2_99(2)) {
            jj_consume_token(START);
            {
                if (true) {
                    return Ok.START;
                }
            }
        } else if (jj_2_100(2)) {
            jj_consume_token(RECOVER);
            {
                if (true) {
                    return Ok.RECOVER;
                }
            }
        } else if (jj_2_101(2)) {
            jj_consume_token(EAR);
            {
                if (true) {
                    return Ok.EAR;
                }
            }
        } else if (jj_2_102(2)) {
            jj_consume_token(SAY);
            {
                if (true) {
                    return Ok.SAY;
                }
            }
        } else if (jj_2_103(2)) {
            jj_consume_token(CHANGE_PLAYER_TYPE);
            {
                if (true) {
                    return Ok.CHANGE_PLAYER_TYPE;
                }
            }
        } else if (jj_2_104(2)) {
            jj_consume_token(LOOK);
            {
                if (true) {
                    return Ok.LOOK;
                }
            }
        } else if (jj_2_105(2)) {
            jj_consume_token(TEAM_NAMES);
            {
                if (true) {
                    return Ok.TEAM_NAMES;
                }
            }
        } else if (jj_2_106(2)) {
            jj_consume_token(TEAM_GRAPHIC);
            {
                if (true) {
                    return Ok.TEAM_GRAPHIC;
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public Errors error() throws ParseException {
        if (jj_2_107(2)) {
            jj_consume_token(ILLEGAL_MODE);
            {
                if (true) {
                    return Errors.ILLEGAL_MODE;
                }
            }
        } else if (jj_2_108(2)) {
            jj_consume_token(ILLEGAL_COMMAND_FORM);
            {
                if (true) {
                    return Errors.ILLEGAL_COMMAND_FORM;
                }
            }
        } else if (jj_2_109(2)) {
            jj_consume_token(ILLEGAL_OBJECT_FORM);
            {
                if (true) {
                    return Errors.ILLEGAL_OBJECT_FORM;
                }
            }
        } else if (jj_2_110(2)) {
            jj_consume_token(NO_MORE_TEAM_OR_PLAYER);
            {
                if (true) {
                    return Errors.NO_MORE_TEAM_OR_PLAYER;
                }
            }
        } else if (jj_2_111(2)) {
            jj_consume_token(NO_MORE_TEAM_OR_PLAYER_OR_GOALIE);
            {
                if (true) {
                    return Errors.NO_MORE_TEAM_OR_PLAYER_OR_GOALIE;
                }
            }
        } else if (jj_2_112(2)) {
            jj_consume_token(RECONNECT);
            {
                if (true) {
                    return Errors.RECONNECT;
                }
            }
        } else if (jj_2_113(2)) {
            jj_consume_token(UNKNOWN_COMMAND);
            {
                if (true) {
                    return Errors.UNKNOWN_COMMAND;
                }
            }
        } else if (jj_2_114(2)) {
            jj_consume_token(TOO_MANY_MOVES);
            {
                if (true) {
                    return Errors.TOO_MANY_MOVES;
                }
            }
        } else if (jj_2_115(2)) {
            jj_consume_token(SAID_TOO_MANY_MESSAGES);
            {
                if (true) {
                    return Errors.SAID_TOO_MANY_MESSAGES;
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public PlayMode playMode() throws ParseException {
        if (jj_2_116(2)) {
            jj_consume_token(BEFORE_KICK_OFF);
            {
                if (true) {
                    return PlayMode.BEFORE_KICK_OFF;
                }
            }
        } else if (jj_2_117(2)) {
            jj_consume_token(TIME_OVER);
            {
                if (true) {
                    return PlayMode.TIME_OVER;
                }
            }
        } else if (jj_2_118(2)) {
            jj_consume_token(PLAY_ON);
            {
                if (true) {
                    return PlayMode.PLAY_ON;
                }
            }
        } else if (jj_2_119(2)) {
            jj_consume_token(KICK_OFF_L);
            if (player.isTeamEast()) {
                if (true) {
                    return PlayMode.KICK_OFF_OTHER;
                }
            } else {
                if (true) {
                    return PlayMode.KICK_OFF_OWN;
                }
            }
        } else if (jj_2_120(2)) {
            jj_consume_token(KICK_OFF_R);
            if (!player.isTeamEast()) {
                if (true) {
                    return PlayMode.KICK_OFF_OTHER;
                }
            } else {
                if (true) {
                    return PlayMode.KICK_OFF_OWN;
                }
            }
        } else if (jj_2_121(2)) {
            jj_consume_token(KICK_IN_L);
            if (player.isTeamEast()) {
                if (true) {
                    return PlayMode.KICK_IN_OTHER;
                }
            } else {
                if (true) {
                    return PlayMode.KICK_IN_OWN;
                }
            }
        } else if (jj_2_122(2)) {
            jj_consume_token(KICK_IN_R);
            if (!player.isTeamEast()) {
                if (true) {
                    return PlayMode.KICK_IN_OTHER;
                }
            } else {
                if (true) {
                    return PlayMode.KICK_IN_OWN;
                }
            }
        } else if (jj_2_123(2)) {
            jj_consume_token(FREE_KICK_R);
            if (!player.isTeamEast()) {
                if (true) {
                    return PlayMode.FREE_KICK_OTHER;
                }
            } else {
                if (true) {
                    return PlayMode.FREE_KICK_OWN;
                }
            }
        } else if (jj_2_124(2)) {
            jj_consume_token(FREE_KICK_L);
            if (player.isTeamEast()) {
                if (true) {
                    return PlayMode.FREE_KICK_OTHER;
                }
            } else {
                if (true) {
                    return PlayMode.FREE_KICK_OWN;
                }
            }
        } else if (jj_2_125(2)) {
            jj_consume_token(FREE_KICK_FAULT_R);
            if (!player.isTeamEast()) {
                if (true) {
                    return PlayMode.FREE_KICK_FAULT_OTHER;
                }
            } else {
                if (true) {
                    return PlayMode.FREE_KICK_FAULT_OWN;
                }
            }
        } else if (jj_2_126(2)) {
            jj_consume_token(FREE_KICK_FAULT_L);
            if (player.isTeamEast()) {
                if (true) {
                    return PlayMode.FREE_KICK_FAULT_OTHER;
                }
            } else {
                if (true) {
                    return PlayMode.FREE_KICK_FAULT_OWN;
                }
            }
        } else if (jj_2_127(2)) {
            jj_consume_token(CORNER_KICK_R);
            if (!player.isTeamEast()) {
                if (true) {
                    return PlayMode.CORNER_KICK_OTHER;
                }
            } else {
                if (true) {
                    return PlayMode.CORNER_KICK_OWN;
                }
            }
        } else if (jj_2_128(2)) {
            jj_consume_token(CORNER_KICK_L);
            if (player.isTeamEast()) {
                if (true) {
                    return PlayMode.CORNER_KICK_OTHER;
                }
            } else {
                if (true) {
                    return PlayMode.CORNER_KICK_OWN;
                }
            }
        } else if (jj_2_129(2)) {
            jj_consume_token(GOAL_KICK_R);
            if (!player.isTeamEast()) {
                if (true) {
                    return PlayMode.GOAL_KICK_OTHER;
                }
            } else {
                if (true) {
                    return PlayMode.GOAL_KICK_OWN;
                }
            }
        } else if (jj_2_130(2)) {
            jj_consume_token(GOAL_KICK_L);
            if (player.isTeamEast()) {
                if (true) {
                    return PlayMode.GOAL_KICK_OTHER;
                }
            } else {
                if (true) {
                    return PlayMode.GOAL_KICK_OWN;
                }
            }
        } else if (jj_2_131(2)) {
            jj_consume_token(GOAL_R);
            if (!player.isTeamEast()) {
                if (true) {
                    return PlayMode.GOAL_OTHER;
                }
            } else {
                if (true) {
                    return PlayMode.GOAL_OWN;
                }
            }
        } else if (jj_2_132(2)) {
            jj_consume_token(GOAL_L);
            if (player.isTeamEast()) {
                if (true) {
                    return PlayMode.GOAL_OTHER;
                }
            } else {
                if (true) {
                    return PlayMode.GOAL_OWN;
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @return
     * @throws ParseException
     */
    final public RefereeMessage refereeMessage() throws ParseException {
        if (jj_2_133(2)) {
            jj_consume_token(OFFSIDE_R);
            if (!player.isTeamEast()) {
                if (true) {
                    return RefereeMessage.OFFSIDE_OTHER;
                }
            } else {
                if (true) {
                    return RefereeMessage.OFFSIDE_OWN;
                }
            }
        } else if (jj_2_134(2)) {
            jj_consume_token(OFFSIDE_L);
            if (player.isTeamEast()) {
                if (true) {
                    return RefereeMessage.OFFSIDE_OTHER;
                }
            } else {
                if (true) {
                    return RefereeMessage.OFFSIDE_OWN;
                }
            }
        } else if (jj_2_135(2)) {
            jj_consume_token(FOUL_R);
            if (!player.isTeamEast()) {
                if (true) {
                    return RefereeMessage.FOUL_OTHER;
                }
            } else {
                if (true) {
                    return RefereeMessage.FOUL_OWN;
                }
            }
        } else if (jj_2_136(2)) {
            jj_consume_token(FOUL_L);
            if (player.isTeamEast()) {
                if (true) {
                    return RefereeMessage.FOUL_OTHER;
                }
            } else {
                if (true) {
                    return RefereeMessage.FOUL_OWN;
                }
            }
        } else if (jj_2_137(2)) {
            jj_consume_token(HALF_TIME);
            {
                if (true) {
                    return RefereeMessage.HALF_TIME;
                }
            }
        } else if (jj_2_138(2)) {
            jj_consume_token(DROP_BALL);
            {
                if (true) {
                    return RefereeMessage.DROP_BALL;
                }
            }
        } else if (jj_2_139(2)) {
            jj_consume_token(TIME_UP);
            {
                if (true) {
                    return RefereeMessage.TIME_UP;
                }
            }
        } else if (jj_2_140(2)) {
            jj_consume_token(TIME_UP_WITHOUT_A_TEAM);
            {
                if (true) {
                    return RefereeMessage.TIME_UP_WITHOUT_A_TEAM;
                }
            }
        } else if (jj_2_141(2)) {
            jj_consume_token(TIME_EXTENDED);
            {
                if (true) {
                    return RefereeMessage.TIME_EXTENDED;
                }
            }
        } else {
            jj_consume_token(-1);
            throw new ParseException();
        }
        throw new Error("Missing return statement in function");
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_1(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_1();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(0, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_2(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_2();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(1, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_3(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_3();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(2, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_4(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_4();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(3, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_5(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_5();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(4, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_6(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_6();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(5, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_7(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_7();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(6, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_8(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_8();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(7, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_9(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_9();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(8, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_10(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_10();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(9, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_11(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_11();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(10, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_12(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_12();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(11, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_13(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_13();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(12, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_14(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_14();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(13, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_15(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_15();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(14, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_16(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_16();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(15, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_17(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_17();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(16, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_18(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_18();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(17, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_19(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_19();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(18, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_20(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_20();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(19, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_21(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_21();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(20, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_22(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_22();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(21, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_23(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_23();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(22, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_24(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_24();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(23, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_25(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_25();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(24, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_26(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_26();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(25, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_27(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_27();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(26, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_28(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_28();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(27, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_29(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_29();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(28, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_30(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_30();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(29, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_31(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_31();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(30, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_32(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_32();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(31, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_33(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_33();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(32, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_34(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_34();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(33, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_35(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_35();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(34, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_36(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_36();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(35, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_37(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_37();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(36, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_38(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_38();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(37, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_39(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_39();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(38, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_40(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_40();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(39, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_41(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_41();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(40, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_42(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_42();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(41, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_43(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_43();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(42, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_44(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_44();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(43, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_45(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_45();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(44, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_46(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_46();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(45, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_47(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_47();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(46, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_48(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_48();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(47, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_49(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_49();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(48, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_50(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_50();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(49, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_51(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_51();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(50, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_52(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_52();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(51, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_53(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_53();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(52, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_54(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_54();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(53, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_55(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_55();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(54, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_56(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_56();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(55, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_57(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_57();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(56, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_58(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_58();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(57, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_59(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_59();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(58, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_60(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_60();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(59, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_61(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_61();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(60, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_62(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_62();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(61, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_63(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_63();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(62, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_64(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_64();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(63, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_65(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_65();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(64, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_66(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_66();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(65, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_67(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_67();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(66, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_68(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_68();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(67, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_69(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_69();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(68, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_70(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_70();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(69, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_71(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_71();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(70, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_72(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_72();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(71, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_73(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_73();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(72, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_74(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_74();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(73, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_75(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_75();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(74, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_76(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_76();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(75, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_77(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_77();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(76, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_78(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_78();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(77, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_79(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_79();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(78, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_80(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_80();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(79, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_81(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_81();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(80, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_82(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_82();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(81, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_83(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_83();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(82, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_84(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_84();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(83, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_85(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_85();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(84, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_86(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_86();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(85, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_87(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_87();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(86, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_88(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_88();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(87, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_89(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_89();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(88, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_90(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_90();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(89, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_91(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_91();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(90, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_92(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_92();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(91, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_93(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_93();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(92, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_94(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_94();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(93, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_95(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_95();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(94, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_96(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_96();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(95, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_97(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_97();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(96, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_98(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_98();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(97, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_99(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_99();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(98, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_100(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_100();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(99, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_101(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_101();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(100, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_102(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_102();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(101, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_103(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_103();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(102, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_104(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_104();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(103, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_105(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_105();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(104, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_106(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_106();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(105, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_107(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_107();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(106, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_108(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_108();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(107, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_109(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_109();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(108, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_110(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_110();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(109, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_111(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_111();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(110, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_112(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_112();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(111, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_113(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_113();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(112, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_114(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_114();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(113, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_115(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_115();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(114, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_116(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_116();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(115, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_117(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_117();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(116, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_118(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_118();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(117, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_119(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_119();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(118, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_120(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_120();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(119, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_121(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_121();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(120, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_122(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_122();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(121, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_123(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_123();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(122, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_124(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_124();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(123, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_125(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_125();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(124, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_126(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_126();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(125, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_127(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_127();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(126, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_128(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_128();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(127, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_129(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_129();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(128, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_130(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_130();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(129, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_131(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_131();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(130, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_132(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_132();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(131, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_133(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_133();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(132, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_134(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_134();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(133, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_135(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_135();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(134, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_136(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_136();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(135, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_137(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_137();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(136, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_138(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_138();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(137, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_139(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_139();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(138, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_140(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_140();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(139, xla);
        }
    }

    /**
     *
     * @param xla
     * @return
     */
    private boolean jj_2_141(int xla) {
        jj_la      = xla;
        jj_lastpos = jj_scanpos = token;
        try {
            return !jj_3_141();
        } catch (LookaheadSuccess ls) {
            return true;
        } finally {
            jj_save(140, xla);
        }
    }

    /**
     *
     * @return
     */
    private boolean jj_3_118() {
        if (jj_scan_token(PLAY_ON)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_117() {
        if (jj_scan_token(TIME_OVER)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_116() {
        if (jj_scan_token(BEFORE_KICK_OFF)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3R_2() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_116()) {
            jj_scanpos = xsp;
            if (jj_3_117()) {
                jj_scanpos = xsp;
                if (jj_3_118()) {
                    jj_scanpos = xsp;
                    if (jj_3_119()) {
                        jj_scanpos = xsp;
                        if (jj_3_120()) {
                            jj_scanpos = xsp;
                            if (jj_3_121()) {
                                jj_scanpos = xsp;
                                if (jj_3_122()) {
                                    jj_scanpos = xsp;
                                    if (jj_3_123()) {
                                        jj_scanpos = xsp;
                                        if (jj_3_124()) {
                                            jj_scanpos = xsp;
                                            if (jj_3_125()) {
                                                jj_scanpos = xsp;
                                                if (jj_3_126()) {
                                                    jj_scanpos = xsp;
                                                    if (jj_3_127()) {
                                                        jj_scanpos = xsp;
                                                        if (jj_3_128()) {
                                                            jj_scanpos = xsp;
                                                            if (jj_3_129()) {
                                                                jj_scanpos = xsp;
                                                                if (jj_3_130()) {
                                                                    jj_scanpos = xsp;
                                                                    if (jj_3_131()) {
                                                                        jj_scanpos = xsp;
                                                                        if (jj_3_132()) {
                                                                            return true;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_115() {
        if (jj_scan_token(SAID_TOO_MANY_MESSAGES)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_14() {
        if (jj_scan_token(OB)) {
            return true;
        }
        if (jj_3R_4()) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_114() {
        if (jj_scan_token(TOO_MANY_MOVES)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_113() {
        if (jj_scan_token(UNKNOWN_COMMAND)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3R_4() {
        if (jj_scan_token(OB)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_15() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        Token xsp;
        if (jj_3_14()) {
            return true;
        }
        while (true) {
            xsp = jj_scanpos;
            if (jj_3_14()) {
                jj_scanpos = xsp;
                break;
            }
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_112() {
        if (jj_scan_token(RECONNECT)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_111() {
        if (jj_scan_token(NO_MORE_TEAM_OR_PLAYER_OR_GOALIE)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_110() {
        if (jj_scan_token(NO_MORE_TEAM_OR_PLAYER)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_109() {
        if (jj_scan_token(ILLEGAL_OBJECT_FORM)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_108() {
        if (jj_scan_token(ILLEGAL_COMMAND_FORM)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_107() {
        if (jj_scan_token(ILLEGAL_MODE)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_106() {
        if (jj_scan_token(TEAM_GRAPHIC)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_105() {
        if (jj_scan_token(TEAM_NAMES)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_104() {
        if (jj_scan_token(LOOK)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_103() {
        if (jj_scan_token(CHANGE_PLAYER_TYPE)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_102() {
        if (jj_scan_token(SAY)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_101() {
        if (jj_scan_token(EAR)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_100() {
        if (jj_scan_token(RECOVER)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_99() {
        if (jj_scan_token(START)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_12() {
        if (jj_scan_token(NORMAL)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_98() {
        if (jj_scan_token(CHECK_BALL)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_97() {
        if (jj_scan_token(CHANGE_MODE)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_96() {
        if (jj_scan_token(MOVE)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_95() {
        if (jj_scan_token(CANNOT_CHANGE_GOALIE)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_94() {
        if (jj_scan_token(MAX_OF_THAT_TYPE_ON_FIELD)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_93() {
        if (jj_scan_token(NO_SUBS_LEFT)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_92() {
        if (jj_scan_token(CANNOT_SUB_WHILE_PLAYON)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_11() {
        if (jj_scan_token(NARROW)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_91() {
        if (jj_scan_token(NO_SUCH_PLAYER)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_9() {
        if (jj_scan_token(LOW)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_90() {
        if (jj_scan_token(NO_TEAM_FOUND)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_89() {
        if (jj_scan_token(C)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_88() {
        if (jj_scan_token(B)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3R_10() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_87()) {
            jj_scanpos = xsp;
            if (jj_3_88()) {
                jj_scanpos = xsp;
                if (jj_3_89()) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_87() {
        if (jj_scan_token(T)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_10() {
        if (jj_scan_token(WIDE)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_8() {
        if (jj_scan_token(HIGH)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_86() {
        if (jj_scan_token(C)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_85() {
        if (jj_scan_token(B)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3R_9() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_84()) {
            jj_scanpos = xsp;
            if (jj_3_85()) {
                jj_scanpos = xsp;
                if (jj_3_86()) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_84() {
        if (jj_scan_token(T)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_7() {
        if (jj_scan_token(R)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_81() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        if (jj_3R_10()) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_80() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        if (jj_3R_9()) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_83() {
        if (jj_scan_token(R)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_81()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_82() {
        if (jj_scan_token(L)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_80()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_6() {
        if (jj_scan_token(L)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_79() {
        if (jj_scan_token(NUM)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_5() {
        if (jj_3R_3()) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_78() {
        if (jj_scan_token(L)) {
            return true;
        }
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_4() {
        if (jj_3R_2()) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_77() {
        if (jj_scan_token(R)) {
            return true;
        }
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_3() {
        if (jj_scan_token(NUM)) {
            return true;
        }
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_2() {
        if (jj_scan_token(REFEREE)) {
            return true;
        }
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_1() {
        if (jj_scan_token(SELF)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_76() {
        if (jj_scan_token(NUM)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_75() {
        if (jj_scan_token(L)) {
            return true;
        }
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_74() {
        if (jj_scan_token(R)) {
            return true;
        }
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_73() {
        if (jj_scan_token(NUM)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_70() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        if (jj_scan_token(NUM)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_72() {
        if (jj_scan_token(B)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_70()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_69() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        if (jj_scan_token(NUM)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_71() {
        if (jj_scan_token(T)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_69()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_68() {
        if (jj_scan_token(NUM)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_65() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        if (jj_scan_token(NUM)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_67() {
        if (jj_scan_token(B)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_65()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_64() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        if (jj_scan_token(NUM)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_66() {
        if (jj_scan_token(T)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_64()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_63() {
        if (jj_scan_token(B)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3R_8() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_62()) {
            jj_scanpos = xsp;
            if (jj_3_63()) {
                return true;
            }
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_62() {
        if (jj_scan_token(T)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_61() {
        if (jj_scan_token(L)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_54() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        if (jj_scan_token(B)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_60() {
        if (jj_scan_token(R)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_59() {
        if (jj_scan_token(B)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_51() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        if (jj_scan_token(B)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_58() {
        if (jj_scan_token(T)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_55() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_53()) {
            jj_scanpos = xsp;
            if (jj_3_54()) {
                return true;
            }
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_53() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        if (jj_scan_token(T)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_57() {
        if (jj_scan_token(R)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_55()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_52() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_50()) {
            jj_scanpos = xsp;
            if (jj_3_51()) {
                return true;
            }
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_50() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        if (jj_scan_token(T)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3R_7() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_56()) {
            jj_scanpos = xsp;
            if (jj_3_57()) {
                return true;
            }
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_56() {
        if (jj_scan_token(L)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_52()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_49() {
        if (jj_scan_token(GOAL)) {
            return true;
        }
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_48() {
        if (jj_scan_token(B)) {
            return true;
        }
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_141() {
        if (jj_scan_token(TIME_EXTENDED)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_47() {
        if (jj_scan_token(T)) {
            return true;
        }
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_140() {
        if (jj_scan_token(TIME_UP_WITHOUT_A_TEAM)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_46() {
        if (jj_scan_token(R)) {
            return true;
        }
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_139() {
        if (jj_scan_token(TIME_UP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_45() {
        if (jj_scan_token(L)) {
            return true;
        }
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_138() {
        if (jj_scan_token(DROP_BALL)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_44() {
        if (jj_scan_token(P)) {
            return true;
        }
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_42() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        if (jj_3R_8()) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_137() {
        if (jj_scan_token(HALF_TIME)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3R_6() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_43()) {
            jj_scanpos = xsp;
            if (jj_3_44()) {
                jj_scanpos = xsp;
                if (jj_3_45()) {
                    jj_scanpos = xsp;
                    if (jj_3_46()) {
                        jj_scanpos = xsp;
                        if (jj_3_47()) {
                            jj_scanpos = xsp;
                            if (jj_3_48()) {
                                jj_scanpos = xsp;
                                if (jj_3_49()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_43() {
        if (jj_scan_token(C)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_42()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_136() {
        if (jj_scan_token(FOUL_L)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_135() {
        if (jj_scan_token(FOUL_R)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_41() {
        if (jj_scan_token(R)) {
            return true;
        }
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_134() {
        if (jj_scan_token(OFFSIDE_L)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_38() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        if (jj_scan_token(GOALIE)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_40() {
        if (jj_scan_token(L)) {
            return true;
        }
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_133() {
        if (jj_scan_token(OFFSIDE_R)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3R_3() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_133()) {
            jj_scanpos = xsp;
            if (jj_3_134()) {
                jj_scanpos = xsp;
                if (jj_3_135()) {
                    jj_scanpos = xsp;
                    if (jj_3_136()) {
                        jj_scanpos = xsp;
                        if (jj_3_137()) {
                            jj_scanpos = xsp;
                            if (jj_3_138()) {
                                jj_scanpos = xsp;
                                if (jj_3_139()) {
                                    jj_scanpos = xsp;
                                    if (jj_3_140()) {
                                        jj_scanpos = xsp;
                                        if (jj_3_141()) {
                                            return true;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_132() {
        if (jj_scan_token(GOAL_L)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_37() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        if (jj_scan_token(NUM)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_131() {
        if (jj_scan_token(GOAL_R)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_130() {
        if (jj_scan_token(GOAL_KICK_L)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3R_5() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_39()) {
            jj_scanpos = xsp;
            if (jj_3_40()) {
                jj_scanpos = xsp;
                if (jj_3_41()) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_39() {
        if (jj_scan_token(NAM)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_37()) {
            jj_scanpos = xsp;
        }
        xsp = jj_scanpos;
        if (jj_3_38()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_31() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        if (jj_3R_7()) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_129() {
        if (jj_scan_token(GOAL_KICK_R)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_36() {
        if (jj_scan_token(GOAL)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_31()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_30() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        if (jj_3R_6()) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_128() {
        if (jj_scan_token(CORNER_KICK_L)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_35() {
        if (jj_scan_token(L)) {
            return true;
        }
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_34() {
        if (jj_scan_token(FLAG)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_30()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_127() {
        if (jj_scan_token(CORNER_KICK_R)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_28() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_29() {
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_28()) {
            jj_scanpos = xsp;
        }
        if (jj_3R_5()) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_33() {
        if (jj_scan_token(B)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_126() {
        if (jj_scan_token(FREE_KICK_FAULT_L)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_32() {
        if (jj_scan_token(P)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_29()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_125() {
        if (jj_scan_token(FREE_KICK_FAULT_R)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_124() {
        if (jj_scan_token(FREE_KICK_L)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_123() {
        if (jj_scan_token(FREE_KICK_R)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_26() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_24() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_22() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_122() {
        if (jj_scan_token(KICK_IN_R)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_20() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_18() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_16() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_121() {
        if (jj_scan_token(KICK_IN_L)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_27() {
        if (jj_scan_token(NUM)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_26()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_25() {
        if (jj_scan_token(NUM)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_24()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_23() {
        if (jj_scan_token(NUM)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_22()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_21() {
        if (jj_scan_token(NUM)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_20()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_19() {
        if (jj_scan_token(NUM)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_18()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_17() {
        if (jj_scan_token(NUM)) {
            return true;
        }
        Token xsp;
        xsp = jj_scanpos;
        if (jj_3_16()) {
            jj_scanpos = xsp;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_120() {
        if (jj_scan_token(KICK_OFF_R)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_13() {
        if (jj_scan_token(SEP)) {
            return true;
        }
        return false;
    }

    /**
     *
     * @return
     */
    private boolean jj_3_119() {
        if (jj_scan_token(KICK_OFF_L)) {
            return true;
        }
        return false;
    }

    /**
     *
     */
    private static void jj_la1_init_0() {
        jj_la1_0 = new int[] {};
    }

    /**
     *
     */
    private static void jj_la1_init_1() {
        jj_la1_1 = new int[] {};
    }

    /**
     *
     */
    private static void jj_la1_init_2() {
        jj_la1_2 = new int[] {};
    }

    /**
     * Reinitialise.
     * @param stream
     */
    public void ReInit(java.io.InputStream stream) {
        ReInit(stream, null);
    }

    /**
     * Reinitialise.
     * @param stream
     * @param encoding
     */
    public void ReInit(java.io.InputStream stream, String encoding) {
        try {
            jj_input_stream.ReInit(stream, encoding, 1, 1);
        } catch (java.io.UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        token_source.ReInit(jj_input_stream);
        token  = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Reinitialise.
     * @param stream
     */
    public void ReInit(java.io.Reader stream) {
        jj_input_stream.ReInit(stream, 1, 1);
        token_source.ReInit(jj_input_stream);
        token  = new Token();
        jj_ntk = -1;
        jj_gen = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     * Reinitialise.
     * @param tm
     */
    public void ReInit(CmdParserPlayerTokenManager tm) {
        token_source = tm;
        token        = new Token();
        jj_ntk       = -1;
        jj_gen       = 0;
        for (int i = 0; i < 0; i++) {
            jj_la1[i] = -1;
        }
        for (int i = 0; i < jj_2_rtns.length; i++) {
            jj_2_rtns[i] = new JJCalls();
        }
    }

    /**
     *
     * @param kind
     * @return
     * @throws ParseException
     */
    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken;
        if ((oldToken = token).next != null) {
            token = token.next;
        } else {
            token = token.next = token_source.getNextToken();
        }
        jj_ntk = -1;
        if (token.kind == kind) {
            jj_gen++;
            if (++jj_gc > 100) {
                jj_gc = 0;
                for (int i = 0; i < jj_2_rtns.length; i++) {
                    JJCalls c = jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return token;
        }
        token   = oldToken;
        jj_kind = kind;
        throw generateParseException();
    }

    /**
     *
     * @param kind
     * @return
     */
    private boolean jj_scan_token(int kind) {
        if (jj_scanpos == jj_lastpos) {
            jj_la--;
            if (jj_scanpos.next == null) {
                jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
            } else {
                jj_lastpos = jj_scanpos = jj_scanpos.next;
            }
        } else {
            jj_scanpos = jj_scanpos.next;
        }
        if (jj_rescan) {
            int   i   = 0;
            Token tok = token;
            while ((tok != null) && (tok != jj_scanpos)) {
                i++;
                tok = tok.next;
            }
            if (tok != null) {
                jj_add_error_token(kind, i);
            }
        }
        if (jj_scanpos.kind != kind) {
            return true;
        }
        if ((jj_la == 0) && (jj_scanpos == jj_lastpos)) {
            throw jj_ls;
        }
        return false;
    }

    /**
     * Get the next Token.
     * @return
     */
    final public Token getNextToken() {
        if (token.next != null) {
            token = token.next;
        } else {
            token = token.next = token_source.getNextToken();
        }
        jj_ntk = -1;
        jj_gen++;
        return token;
    }

    /**
     * Get the specific Token.
     * @param index
     * @return
     */
    final public Token getToken(int index) {
        Token t = token;
        for (int i = 0; i < index; i++) {
            if (t.next != null) {
                t = t.next;
            } else {
                t = t.next = token_source.getNextToken();
            }
        }
        return t;
    }

    /**
     *
     * @return
     */
    private int jj_ntk() {
        if ((jj_nt = token.next) == null) {
            return (jj_ntk = (token.next = token_source.getNextToken()).kind);
        } else {
            return (jj_ntk = jj_nt.kind);
        }
    }

    /**
     *
     * @param kind
     * @param pos
     */
    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == jj_endpos + 1) {
            jj_lasttokens[jj_endpos++] = kind;
        } else if (jj_endpos != 0) {
            jj_expentry = new int[jj_endpos];
            for (int i = 0; i < jj_endpos; i++) {
                jj_expentry[i] = jj_lasttokens[i];
            }
            jj_entries_loop:
            for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext(); ) {
                int[] oldentry = (int[]) (it.next());
                if (oldentry.length == jj_expentry.length) {
                    for (int i = 0; i < jj_expentry.length; i++) {
                        if (oldentry[i] != jj_expentry[i]) {
                            continue jj_entries_loop;
                        }
                    }
                    jj_expentries.add(jj_expentry);
                    break jj_entries_loop;
                }
            }
            if (pos != 0) {
                jj_lasttokens[(jj_endpos = pos) - 1] = kind;
            }
        }
    }

    /**
     * Generate ParseException.
     * @return
     */
    public ParseException generateParseException() {
        jj_expentries.clear();
        boolean[] la1tokens = new boolean[88];
        if (jj_kind >= 0) {
            la1tokens[jj_kind] = true;
            jj_kind            = -1;
        }
        for (int i = 0; i < 0; i++) {
            if (jj_la1[i] == jj_gen) {
                for (int j = 0; j < 32; j++) {
                    if ((jj_la1_0[i] & (1 << j)) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((jj_la1_1[i] & (1 << j)) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    if ((jj_la1_2[i] & (1 << j)) != 0) {
                        la1tokens[64 + j] = true;
                    }
                }
            }
        }
        for (int i = 0; i < 88; i++) {
            if (la1tokens[i]) {
                jj_expentry    = new int[1];
                jj_expentry[0] = i;
                jj_expentries.add(jj_expentry);
            }
        }
        jj_endpos = 0;
        jj_rescan_token();
        jj_add_error_token(0, 0);
        int[][] exptokseq = new int[jj_expentries.size()][];
        for (int i = 0; i < jj_expentries.size(); i++) {
            exptokseq[i] = jj_expentries.get(i);
        }
        return new ParseException(token, exptokseq, tokenImage);
    }

    /** Enable tracing. */
    final public void enable_tracing() {}

    /** Disable tracing. */
    final public void disable_tracing() {}

    /**
     *
     */
    private void jj_rescan_token() {
        jj_rescan = true;
        for (int i = 0; i < 141; i++) {
            try {
                JJCalls p = jj_2_rtns[i];
                do {
                    if (p.gen > jj_gen) {
                        jj_la      = p.arg;
                        jj_lastpos = jj_scanpos = p.first;
                        switch (i) {
                            case 0 :
                                jj_3_1();
                                break;
                            case 1 :
                                jj_3_2();
                                break;
                            case 2 :
                                jj_3_3();
                                break;
                            case 3 :
                                jj_3_4();
                                break;
                            case 4 :
                                jj_3_5();
                                break;
                            case 5 :
                                jj_3_6();
                                break;
                            case 6 :
                                jj_3_7();
                                break;
                            case 7 :
                                jj_3_8();
                                break;
                            case 8 :
                                jj_3_9();
                                break;
                            case 9 :
                                jj_3_10();
                                break;
                            case 10 :
                                jj_3_11();
                                break;
                            case 11 :
                                jj_3_12();
                                break;
                            case 12 :
                                jj_3_13();
                                break;
                            case 13 :
                                jj_3_14();
                                break;
                            case 14 :
                                jj_3_15();
                                break;
                            case 15 :
                                jj_3_16();
                                break;
                            case 16 :
                                jj_3_17();
                                break;
                            case 17 :
                                jj_3_18();
                                break;
                            case 18 :
                                jj_3_19();
                                break;
                            case 19 :
                                jj_3_20();
                                break;
                            case 20 :
                                jj_3_21();
                                break;
                            case 21 :
                                jj_3_22();
                                break;
                            case 22 :
                                jj_3_23();
                                break;
                            case 23 :
                                jj_3_24();
                                break;
                            case 24 :
                                jj_3_25();
                                break;
                            case 25 :
                                jj_3_26();
                                break;
                            case 26 :
                                jj_3_27();
                                break;
                            case 27 :
                                jj_3_28();
                                break;
                            case 28 :
                                jj_3_29();
                                break;
                            case 29 :
                                jj_3_30();
                                break;
                            case 30 :
                                jj_3_31();
                                break;
                            case 31 :
                                jj_3_32();
                                break;
                            case 32 :
                                jj_3_33();
                                break;
                            case 33 :
                                jj_3_34();
                                break;
                            case 34 :
                                jj_3_35();
                                break;
                            case 35 :
                                jj_3_36();
                                break;
                            case 36 :
                                jj_3_37();
                                break;
                            case 37 :
                                jj_3_38();
                                break;
                            case 38 :
                                jj_3_39();
                                break;
                            case 39 :
                                jj_3_40();
                                break;
                            case 40 :
                                jj_3_41();
                                break;
                            case 41 :
                                jj_3_42();
                                break;
                            case 42 :
                                jj_3_43();
                                break;
                            case 43 :
                                jj_3_44();
                                break;
                            case 44 :
                                jj_3_45();
                                break;
                            case 45 :
                                jj_3_46();
                                break;
                            case 46 :
                                jj_3_47();
                                break;
                            case 47 :
                                jj_3_48();
                                break;
                            case 48 :
                                jj_3_49();
                                break;
                            case 49 :
                                jj_3_50();
                                break;
                            case 50 :
                                jj_3_51();
                                break;
                            case 51 :
                                jj_3_52();
                                break;
                            case 52 :
                                jj_3_53();
                                break;
                            case 53 :
                                jj_3_54();
                                break;
                            case 54 :
                                jj_3_55();
                                break;
                            case 55 :
                                jj_3_56();
                                break;
                            case 56 :
                                jj_3_57();
                                break;
                            case 57 :
                                jj_3_58();
                                break;
                            case 58 :
                                jj_3_59();
                                break;
                            case 59 :
                                jj_3_60();
                                break;
                            case 60 :
                                jj_3_61();
                                break;
                            case 61 :
                                jj_3_62();
                                break;
                            case 62 :
                                jj_3_63();
                                break;
                            case 63 :
                                jj_3_64();
                                break;
                            case 64 :
                                jj_3_65();
                                break;
                            case 65 :
                                jj_3_66();
                                break;
                            case 66 :
                                jj_3_67();
                                break;
                            case 67 :
                                jj_3_68();
                                break;
                            case 68 :
                                jj_3_69();
                                break;
                            case 69 :
                                jj_3_70();
                                break;
                            case 70 :
                                jj_3_71();
                                break;
                            case 71 :
                                jj_3_72();
                                break;
                            case 72 :
                                jj_3_73();
                                break;
                            case 73 :
                                jj_3_74();
                                break;
                            case 74 :
                                jj_3_75();
                                break;
                            case 75 :
                                jj_3_76();
                                break;
                            case 76 :
                                jj_3_77();
                                break;
                            case 77 :
                                jj_3_78();
                                break;
                            case 78 :
                                jj_3_79();
                                break;
                            case 79 :
                                jj_3_80();
                                break;
                            case 80 :
                                jj_3_81();
                                break;
                            case 81 :
                                jj_3_82();
                                break;
                            case 82 :
                                jj_3_83();
                                break;
                            case 83 :
                                jj_3_84();
                                break;
                            case 84 :
                                jj_3_85();
                                break;
                            case 85 :
                                jj_3_86();
                                break;
                            case 86 :
                                jj_3_87();
                                break;
                            case 87 :
                                jj_3_88();
                                break;
                            case 88 :
                                jj_3_89();
                                break;
                            case 89 :
                                jj_3_90();
                                break;
                            case 90 :
                                jj_3_91();
                                break;
                            case 91 :
                                jj_3_92();
                                break;
                            case 92 :
                                jj_3_93();
                                break;
                            case 93 :
                                jj_3_94();
                                break;
                            case 94 :
                                jj_3_95();
                                break;
                            case 95 :
                                jj_3_96();
                                break;
                            case 96 :
                                jj_3_97();
                                break;
                            case 97 :
                                jj_3_98();
                                break;
                            case 98 :
                                jj_3_99();
                                break;
                            case 99 :
                                jj_3_100();
                                break;
                            case 100 :
                                jj_3_101();
                                break;
                            case 101 :
                                jj_3_102();
                                break;
                            case 102 :
                                jj_3_103();
                                break;
                            case 103 :
                                jj_3_104();
                                break;
                            case 104 :
                                jj_3_105();
                                break;
                            case 105 :
                                jj_3_106();
                                break;
                            case 106 :
                                jj_3_107();
                                break;
                            case 107 :
                                jj_3_108();
                                break;
                            case 108 :
                                jj_3_109();
                                break;
                            case 109 :
                                jj_3_110();
                                break;
                            case 110 :
                                jj_3_111();
                                break;
                            case 111 :
                                jj_3_112();
                                break;
                            case 112 :
                                jj_3_113();
                                break;
                            case 113 :
                                jj_3_114();
                                break;
                            case 114 :
                                jj_3_115();
                                break;
                            case 115 :
                                jj_3_116();
                                break;
                            case 116 :
                                jj_3_117();
                                break;
                            case 117 :
                                jj_3_118();
                                break;
                            case 118 :
                                jj_3_119();
                                break;
                            case 119 :
                                jj_3_120();
                                break;
                            case 120 :
                                jj_3_121();
                                break;
                            case 121 :
                                jj_3_122();
                                break;
                            case 122 :
                                jj_3_123();
                                break;
                            case 123 :
                                jj_3_124();
                                break;
                            case 124 :
                                jj_3_125();
                                break;
                            case 125 :
                                jj_3_126();
                                break;
                            case 126 :
                                jj_3_127();
                                break;
                            case 127 :
                                jj_3_128();
                                break;
                            case 128 :
                                jj_3_129();
                                break;
                            case 129 :
                                jj_3_130();
                                break;
                            case 130 :
                                jj_3_131();
                                break;
                            case 131 :
                                jj_3_132();
                                break;
                            case 132 :
                                jj_3_133();
                                break;
                            case 133 :
                                jj_3_134();
                                break;
                            case 134 :
                                jj_3_135();
                                break;
                            case 135 :
                                jj_3_136();
                                break;
                            case 136 :
                                jj_3_137();
                                break;
                            case 137 :
                                jj_3_138();
                                break;
                            case 138 :
                                jj_3_139();
                                break;
                            case 139 :
                                jj_3_140();
                                break;
                            case 140 :
                                jj_3_141();
                                break;
                        }
                    }
                    p = p.next;
                } while (p != null);
            } catch (LookaheadSuccess ls) {}
        }
        jj_rescan = false;
    }

    /**
     *
     * @param index
     * @param xla
     */
    private void jj_save(int index, int xla) {
        JJCalls p = jj_2_rtns[index];
        while (p.gen > jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen   = jj_gen + xla - jj_la;
        p.first = token;
        p.arg   = xla;
    }

    /**
     *
     * @author author
     */
    static final class JJCalls {
        int     arg;
        Token   first;
        int     gen;
        JJCalls next;
    }

    /**
     *
     * @author author
     */
    static private final class LookaheadSuccess extends java.lang.Error {}
}
