package plplan.javaapi;

import java.util.ArrayList;
import java.util.List;


/**
 * This class is a test class. It use the PLPlan class to create new facts, goal facts, 
 * and operators, and then to find a plan for it.
 * 
 * PLPLAN
 * Authors : Philippe Fournier-Viger and Ludovic lebel
 * <p>
 * This work is licensed under the Creative Commons Attribution 2.5 License. To
 * view a copy of this license, visit
 * http://creativecommons.org/licenses/by/2.5/ or send a letter to Creative
 * Commons, 543 Howard Street, 5th Floor, San Francisco, California, 94105, USA.
 * <p>
 * If you use PLPLAN, we ask you to mention our names and our webpage URL in your work. 
 * The PLPLAN software is copyrighted by Philippe Fournier-Viger and Ludovic Lebel (2005). 
 * Please read carefully the license to know what you can do and cannot do with this software. 
 * You can contact Philippe Fournier-Viger for special permissions. 
 * <p>
 * This sofware is provided "as is", without warranty of any kind. 
 * The user takes the entire risk as to the quality and performance of the software. 
 * The authors accept no responsibility for any problem the user encounters using this software.
 * <p>
 * @author Philippe Fournier-Viger and Ludovic Lebel
 */
public class Example3 {

    @SuppressWarnings("unchecked")
	public static void main(String[] args) throws PlPlanException {

        System.out.println("-- TEST1 --");
        // Create a planning problem, and then find a plan
        // This problem is based on Blockworld
        
    	PLPlan planner = new PLPlan();
        planner.setAlgorithm(EnumAlgorithm.GRAPHPLAN);
    	
    	List<String> precond = new ArrayList<String>();
    	List<String> neg = new ArrayList<String>();
        List<String> pos = new ArrayList<String>();
        
    	//action score-goal
    	
    	precond = new ArrayList<String>();
        precond.add("have-ball");
        precond.add("can-see-goal");
        precond.add("clean-field");
        neg = new ArrayList<String>();
        neg.add("have-ball");
        pos = new ArrayList<String>();
        pos.add("ball-in-net");
        planner.addOperator("score-goal", precond, neg, pos);
        
        //action find-goal
        
    	precond = new ArrayList<String>();
        neg = new ArrayList<String>();
        pos = new ArrayList<String>();
        pos.add("can-see-goal");
        planner.addOperator("find-goal", precond, neg, pos);
        
        //action run-to-ball
        
    	precond = new ArrayList<String>();
        precond.add("can-see-ball");
        neg = new ArrayList<String>();
        pos = new ArrayList<String>();
        pos.add("have-ball");
        planner.addOperator("run-to-ball", precond, neg, pos);
        
        //action find-ball
        
    	precond = new ArrayList<String>();
        neg = new ArrayList<String>();
        pos = new ArrayList<String>();
        pos.add("can-see-ball");
        planner.addOperator("find-ball", precond, neg, pos);
        
        //action dribble
        
    	precond = new ArrayList<String>();
    	precond.add("have-ball");
        neg = new ArrayList<String>();
        pos = new ArrayList<String>();
        pos.add("clean-field");
        planner.addOperator("dribble", precond, neg, pos);
        
        planner.addFact("can-see-goal");
        planner.addGoalFact("ball-in-net");
        
        List resultats = planner.findPlan();
        System.out.println(planner.getPlanningOutput());
        System.out.println(resultats);
      
        
    }
}
