package robocup.lab;
/**
 * The Class Literal.
 */
public class Literal implements Comparable<Literal> {
	
	/**
	 * The literal priority.
	 */
	private Integer priority;
	
	/**
	 * The literal name.
	 */
	private String name;

	/**
	 * Instantiates a new literal.
	 *
	 * @param n the literal name
	 */
	public Literal(String n) {
		this.name = n;
		
		if (n.equals("ball-in-net"))
			this.priority = 10;
		
		else if (n.equals("clear-field"))
			this.priority = 20;
		
		else if (n.equals("can-score"))
			this.priority = 30;
		
		else if (n.equals("can-see-goal"))
			this.priority = 40;
		
		else if (n.equals("can-see-area"))
			this.priority = 45;
		
		else if (n.equals("have-ball"))
			this.priority = 50;
		
		else if (n.equals("can-see-ball"))
			this.priority = 100;
		
	}

	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	@Override
	public int compareTo(Literal o) {
		return priority.compareTo(o.priority);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Literal other = (Literal) obj;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		return true;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return getName();
	}

	/**
	 * Gets the priority.
	 *
	 * @return the priority
	 */
	public Integer getPriority() {
		return priority;
	}

	/**
	 * Sets the priority.
	 *
	 * @param priority the new priority
	 */
	public void setPriority(Integer priority) {
		this.priority = priority;
	}

	/**
	 * Gets the name.
	 *
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Sets the name.
	 *
	 * @param name the new name
	 */
	public void setName(String name) {
		this.name = name;
	}

}
